

# todo improve unicode handling 
# todo put get jar from maven (ie build.gradle)todo timeout in waitForMessages
# todo stop interleaving 2 thread log messages

# USEFUL NOTE TO DEVS if you get hanging tests, you may have to kill a leftover java server
# netstat -o will show pid, then look for pid of port 2718, and
# taskkill /f /pid <pid>




import unittest
import sys
import subprocess
import socket
from io import StringIO
import signal
import random
import time
import gaslink
from gassupport import *

from py4j.java_gateway import *

from signalling_test import Signalling_Test

# DO NOT DO ANY Q IMPORTS  HERE (or things that do) - SEE COMMENT #IMPORT QT IN MAIN
# from qgis.PyQt.QtCore import *


# This can be anything
PY4J_PORT = 4577

# Gas side is reading a config file, so we have to use this same value on py side (2718) (todo allow tests to use another port)
GASLINK_PORT = 2718

# THIS IS THE NAME THAT THE PYTHONSERVER  is expecting - so you should use it to be allowed to connect
GLM_CLIENT_NAME = "PyUnitTest"

# module level as can't figure out how to pass properties into the class (for silentmode)
_signalling = Signalling_Test() # placeholder

class Test_LiveLink(unittest.TestCase):

    @classmethod
    def setUpClass(cls):
        _signalling.log(0,'setUpClass',f'>>> SETUP of test class  {str(cls)}')
        cls.gasGate, cls.childPid, cls.gateway = setupGasGate()

    @classmethod
    def tearDownClass(cls):
        _signalling.log(0,'tearDownClass',f'>>> TEARDOWN of test class  {str(cls)}')
        shutdownGasGate(cls.childPid, cls.gateway)

    
    def test_connectOnly(self):
        testName='test_connectOnly'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  

            # use gateway to start gas
            signalling.log(0,testName,'starting gas main')
            gasGate.start()

            # connect the client
            glmClient = GasLinkClient_Test(signalling) 
            glmClient.startListener()  
            glmClient.waitForMessages(2) #only 2 when no data in gas
            
            # ok at both ends, but no data
            self.assertTrue(glmClient.connected)
            self.assertTrue(gasGate.getGasLink().haveClient())
            self.assertEqual("QGIS", gasGate.getGasLink().getClientName())
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006
            gd = glmClient.gasData
            self.assertEqual([], gd.data)
            
        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()
    
    
    def test_fileLoadAndAttMessage(self):
        testName='test_fileLoadAndAttMessage'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  # for convenicne

            # use gateway to start gas
            signalling.log(0,testName,'starting gas main')
            gasGate.start()
            gasGate.importGasFile(os.path.join("testdata","gis.small.gas"))

            # assert that gas has the loaded file, but no client
            f = gasGate.getLoadedFile()
            self.assertEqual("gis.small.gas", os.path.basename(f))
            self.assertFalse(gasGate.getGasLink().haveClient())
            
            # try the client

            #print('about to constr client')
            glmClient = GasLinkClient_Test(signalling) 
            #print('about to start listener')
            glmClient.startListener() 
            glmClient.waitForMessages(3) # less than 3 and we do checks below too fast.  MORE than 3 we will block here.
                      
            # assert gas thinks it has one
            gaslink = gasGate.getGasLink()
            signalling.log(0,testName,f'python client class connected, and (JAVA) SERVER reports gaslink client is {gaslink.getClientName()} ver {gaslink.getClientVersionInt()}')
            self.assertTrue(gasGate.getGasLink().haveClient())
            self.assertEqual("QGIS", gasGate.getGasLink().getClientName())
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006

            gd = glmClient.gasData

            # check "table" name on py side - that we have successfully removed prefix and any filename extension
            self.assertEqual('gis.small', gd.name)

            # check row count on python side
            self.assertEqual(9, len(gd.data))

            # check meta data
            self.assertEqual("east", gd.specialColumnEast)
            self.assertEqual("north", gd.specialColumnNorth)
            self.assertEqual("32613", gd.specialColumnEPSG) # .gas file is utm zone 13
            
            # check colour name
            self.assertEqual("A", gd.colours[1].name) 
            self.assertTrue(gd.colours[1].visible)
            
            # change colour viz on gas end to make 3 rows not visible
            cd = gasGate.getChartData()
            atts = cd.getAttributes()
            colours = atts.getColourAttributes()
            
            try:
                # ioGAS 8.0 version
                colours.get(1).transactionSetVisible(False)
            except:
                # ioGAS 7.4 version, after release this case can be deleted in trunk
                colours.get(1).setVisible(False)
            glmClient.waitForMessages(1)
                                    
            # check row count and colour viz on python side
            # - ie we got a message about colour viz  change
            self.assertEqual(9 -3, len(gd.data))
            self.assertFalse(gd.colours[1].visible)
        
		# TODO Review this exception    
        #except Exception as e:
            #print(f"r ERR {str(e)}" )

        finally:
            # use gateway to stop gas, and so stop gaslink server - will do at end of each unit test
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()
   

    def test_uniqueAtts(self):
        testName = 'test_uniqueAtts'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            
            gasGate = self.gasGate  # for convenicne

            # use gateway to start gas
            signalling.log(0,testName,f'starting gas main')
            gasGate.start()
            gasGate.importGasFile(os.path.join("testdata","gis.small.ua.gas"))

            # assert that gas has the loaded file, but no client
            f = gasGate.getLoadedFile()
            self.assertEqual("gis.small.ua.gas", os.path.basename(f))
            self.assertFalse(gasGate.getGasLink().haveClient())
            
            # try the client

            #print('about to constr client')
            glmClient = GasLinkClient_Test(signalling) 
            #print('about to start listener')
            glmClient.startListener() 
            glmClient.waitForMessages(3) 
                      
            
            # assert gas thinks it has one
            gaslink = gasGate.getGasLink()
            signalling.log(0,testName,f'python client class connected, and (JAVA) SERVER reports gaslink client is {gaslink.getClientName()} ver {gaslink.getClientVersionInt()}')
            self.assertTrue(gasGate.getGasLink().haveClient())
            self.assertEqual("QGIS", gasGate.getGasLink().getClientName())
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006
            
            # check row count on python side
            d = glmClient.gasData.data
            self.assertEqual(8, len(d))
                        
            # check the unique att combinations
            gd = glmClient.gasData
            self.assertEqual(4, len(gd.uniqueAttCombinations)) # was 6 prior to bugfix #4390
            self.assertEqual((1,1,0), (gd.uniqueAttCombinations[0]))
          
		# TODO Review this exception              
        #except Exception as e:
            #print(f"r ERR {str(e)}" )

        finally:
            # use gateway to stop gas, and so stop gaslink server - will do at end of each unit test
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()

   
    # THIS  is a very complicated test to confirm that hanging client does not hang gas after java fix in #4370
    # it also confirmed that 7.3 gas does hang.  You can repeat this by setting  gaslink.setSynchronous(True) #NOTE 1#
    # AND by changing to a gtk to a huge .gas file (tenmil.gas, not checked in as its 40M. you can make one with ten million random cells)    
    def untest_clientHang(self):
        testName='test_clientHang'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  

            # use gateway to start gas
            signalling.log(0,testName,'starting gas main')
            gasGate.start()
            #gasGate.importGasFile("testdata/tenmil.gas")
            gasGate.importGasFile(os.path.join("testdata","gtk.gas"))
            gaslink = gasGate.getGasLink()
            
            # set to synch mode to let gas lockup (don't do this!) ###
            # gaslink.setSynchronous(True) #NOTE 1#

            # assert that gas has the loaded file, but no client
            f = gasGate.getLoadedFile()
            self.assertEqual("gtk.gas", os.path.basename(f)) #10 cols by 1 million rows
            self.assertFalse(gasGate.getGasLink().haveClient())
            
            # try the client
            #print('about to constr client')
            glmClient = GasLinkClient_Test(signalling, pHangTesting = True) # hash char in stream will provoke a deliberate client hang
            #print('about to start listener')
            glmClient.startListener() 
            glmClient.waitForMessages(3) # less than 3 and we do checks below too fast.  MORE than 3 we will block here.
            signalling.log(0,testName,'got 3 messages') 
   
            
            # assert gas has client
            self.assertTrue(gasGate.getGasLink().haveClient())
            self.assertEqual("QGIS", gasGate.getGasLink().getClientName())
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006
            
            #assert client has correct row count (gtk)
            d = glmClient.gasData.data
            self.assertEqual(6545, len(d))
                      
            # change colour name 
            cd = gasGate.getChartData()
            atts = cd.getAttributes()
            colours = atts.getColourAttributes()

            colours.get(0).setName("purple") 
            glmClient.waitForMessages(1) # wait for the att message

            c = glmClient.gasData.colours[0].name
            signalling.log(0,testName,f'colour name is {c}')
            self.assertEqual("purple", c)

            # change colour name again              
            # the hash char will provoke hanging client (used to cause gas to hang)
            colours.get(0).setName("#pink") 
            

            signalling.log(0,testName,'2ND SETNAME CALL EXITED') 
            # SEE #NOTE 1#
            #IN ASYNC MODE YOU GET HERE after nearly two minutes (with tenmil.gas)
            # the assert below #NOTE 2# will fail as the client is hung
            # BUT GAS IS OK
            
            # IN SYNC MODE,  YOU NEVER GET HERE AS GAS IS HUNG (with tenmil.gas  - with a smaller file it won't hang)
            # trying to write to full tcp buffers, in response to the synch setName call
            
            
            c = glmClient.gasData.colours[0].name
            signalling.log(0,testName,f'2nd time colour name is {c}')

            # this fails if Hang Testing is True because the colour wasn't changed 2nd time
            ### self.assertEqual("#pink", c) #NOTE 2#
            
		# TODO Review this exception              
        #except Exception as ee:
            #print("test_clientHang TEST ERR " + str(ee.args))
             

        finally:
            # use gateway to stop gas, and so stop gaslink server - will do at end of each unit test
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()
            
            

    
    def test_nonearth(self):
        testName='test_non earth'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate 

            # use gateway to start gas
            gasGate.start()
            gasGate.importGasFile(os.path.join("testdata","gis.small.nonearth.gas")) #epsg is zero

            # try the client
            glmClient = GasLinkClient_Test(signalling) 
            glmClient.startListener()  # connect, send GLMConnect, and start listening for messages
            glmClient.waitForMessages(3) 
            

            # assert gas thinks it has one
            gaslink = gasGate.getGasLink()
            
            signalling.log(0,testName,f'python client class connected, and (JAVA) SERVER reports gaslink client is {gaslink.getClientName()} ver {gaslink.getClientVersionInt()}')
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006
            
            # check row count on python side
            g = glmClient.gasData
            self.assertEqual(9, len(g.data))

            # check epsg code            
            self.assertEqual("east", g.specialColumnEast)
            self.assertEqual("north", g.specialColumnNorth)
            self.assertEqual("0", g.specialColumnEPSG)

        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()
           
               
    def test_data_and_nonascii_data(self):
        testName='test_nonascii'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  

            # use gateway to start gas
            gasGate.start()
            gasGate.importGasFile(os.path.join("testdata","unicode.ansi.gas")) #epsg is zero

            # try the client
            glmClient = GasLinkClient_Test(signalling) 
            glmClient.startListener()  
            glmClient.waitForMessages(3)

            # assert gas thinks it has one
            gaslink = gasGate.getGasLink()
            signalling.log(0,testName,f'python client class connected, and (JAVA) SERVER reports gaslink client is {gaslink.getClientName()} ver {gaslink.getClientVersionInt()}')
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006
            
            
            #id,copper,desc,east,north,__gas__extra__, __gas__color__, __gas__shape__, __gas__size__
            #1,2,blah,1,1,0,0,0,0
            #2,3,L[non printable char],2,2,0,0,0,0
            #3,4,L[non printable char],3,3,0,0,0,0

            # check row count on python side
            d = glmClient.gasData.data
            self.assertEqual(3, len(d))
            
            # check data in first row
            self.assertEqual(1.0, d[0][0]) #id numeric
            self.assertEqual(2.0, d[0][1]) #copper numeric
            self.assertEqual("blah", d[0][2]) #blah text
            
            # ansi encoded test file, so single byte >127, 
            # but that was converted to two byte utf-8, so python client 
            # has made that __ (workaround to crashing)

            # # ansi encoded test file, so single byte >127
            if get_os_platform() == PLATFORM_WIN :
                self.assertEqual("L__", d[1][2]) # whereas ON WINDOWS converted to _
            else : # mac
                self.assertEqual("L___", d[1][2])   # Note on Mac os non ascii seems to get converted to __
   
        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()

 
    def test_nonnumeric(self):
        testName='test_nonnumeric'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  

            # use gateway to start gas
            gasGate.start()
            gasGate.importGasFile(os.path.join("testdata","GIS.SMALL.text_in_tin.gas")) # has non numerics

            # test file has non numerics in numeric columns in 2nd row xx in tin field, yy in 3rd row lead field
            # id,   east,   north,  RL, code,   copper_,tin,lead,atta,attb,attc,filt,__gas__extra__, __gas__color__, __gas__shape__, __gas__size__
            # 1,    500000, 450600, 40, hello,  4,      ,   4,  A,  aa, _ux,    y,0,0,0,0
            # 2,    500400, 450050, 55, there_u1,,      xx, 6,  B,  bb,y,y,0,0,0,0
            # 3,    500000, 455555, 66, ,       4,      6,  yy, C,aa,z,y,0,0,0,0
            
            # try the client
            glmClient = GasLinkClient_Test(signalling) 
            glmClient.startListener()  
            glmClient.waitForMessages(3)

            # assert gas thinks it has one
            gaslink = gasGate.getGasLink()
            signalling.log(0,testName,f'python client class connected, and (JAVA) SERVER reports gaslink client is {gaslink.getClientName()} ver {gaslink.getClientVersionInt()}')
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006
            
            # check row count on python side
            d = glmClient.gasData.data
            
            self.assertEqual(10, len(d))  # num data rows loaded
            self.assertEqual(None, d[1][6])  # xx in row 2 tin should be replaced with non
            self.assertEqual(None, d[2][7])
            self.assertEqual(6, d[2][6])
          
                        
        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()


    #test bad client name
    def test_badName_and_reconnect(self):
        testName='test_badName_and_reconnect'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  

            # use gateway to start gas
            gasGate.start()

            # try  - it will not be allowed with this typename
            glmClient = GasLinkClient_Test(signalling, "badName") 
            glmClient.startListener() 
            glmClient.waitForMessages(1)

            
            # assert gas has no client
            gaslink = gasGate.getGasLink()
            self.assertFalse(gasGate.getGasLink().haveClient())
            
            # and we think we have no connection
            # allow time for python internal signalling to catch up
            time.sleep(1)
            self.assertFalse(glmClient.connected)
            
            # now wait a second and reconnect a new client with the GOOD client name
            # NOTE this is not a realistic test as we cannot change client name
            time.sleep(1)
            glmClient2 = GasLinkClient_Test(signalling) 
            glmClient2.startListener() 
            glmClient2.waitForMessages(2)
            
            # assert gas has client
            gaslink = gasGate.getGasLink()
            self.assertTrue(gasGate.getGasLink().haveClient())
            
            # and we think we have connection
            # allow time for internal signalling...
            # time.sleep(1) # don't need this time as we have waited above for two messages
            self.assertTrue(glmClient2.connected)
            
    
        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()
            
            
    # test connecting to 'old' gas server, that will reject connection,
    # then reconnecting to a new one ok
    def test_badServer_and_reconnect(self):
        testName='badServer_and_reconnect'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            
            # start a server that won't allow QGIS connection type
            gasGate = self.gasGate  
            gasGate.start()
            gaslink = gasGate.getGasLink()
            signalling.log(0,testName,f'server allows {gasGate.getGasLinkAllowedClients()}\n')
            # new list q = gateway.jvm.java.util.ArrayList()
            gasGate.getGasLinkAllowedClients().remove("QGIS")
            signalling.log(0,testName,f'now server allows {gasGate.getGasLinkAllowedClients()}\n')

            # try to connect
            glmClient = GasLinkClient_Test(signalling) 
            glmClient.startListener() 
            glmClient.waitForMessages(1)
            
            # assert gas has no client
            gaslink = gasGate.getGasLink()
            self.assertFalse(gasGate.getGasLink().haveClient())
            
            # and we think we have no connection
            # allow time for python internal signalling to catch up
            time.sleep(1)
            self.assertFalse(glmClient.connected)
            
            # change servers allowed list
            signalling.log(0,testName,f'server allows {gasGate.getGasLinkAllowedClients()}\n')
            gasGate.getGasLinkAllowedClients().add("QGIS")
            signalling.log(0,testName,f'now server allows {gasGate.getGasLinkAllowedClients()}\n')
            
            # connect same client again
            glmClient.startListener() 
            glmClient.waitForMessages(1)
            
            # assert gas has  client
            gaslink = gasGate.getGasLink()
            self.assertTrue(gasGate.getGasLink().haveClient())
            
            # and we think we have  connection
            # allow time for python internal signalling to catch up
            time.sleep(1)
            self.assertTrue(glmClient.connected)
            
    
        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()
            
            
    def test_dataToGas(self):
        testName='test_dataToGas'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  

            # use gateway to start gas
            gasGate.start()

            # connect the client
            glmClient = GasLinkClient_Test(signalling) 
            glmClient.setTestViews(['view1', 'view2'])
            glmClient.setTestEpsg('28350') #mga zone 50
            glmClient.setTestEast('col3') 
            glmClient.setTestNorth('col4') 
            glmClient.startListener()  
            glmClient.waitForMessages(2)

            # ask client for view list
            gaslink = gasGate.getGasLink()
            dummyController = gasGate.getActionController() # A dummy one that won't ever report user pressed cancel
            views = gaslink.getAvailableViews(dummyController); # blocked here until python client has responded
            
            # check view list
            # glmClient.waitForMessages(1) # not necessary
            signalling.log(0,testName,f"server got views available {views}")
            self.assertEqual("view1", views[0])
            self.assertEqual("view2", views[1])
            
            # ask for data
            cd = gaslink.buildChartData("view1", dummyController) #blocks
            
            # check data on gas side
            signalling.log(0,testName,f" cd {str(cd.toString())}")
            col = cd.getColumnByName("col2"); # 2,6 is the data
            self.assertEqual(2, col.sizeNumbers());
            self.assertEqual(4.0, col.getMeanValue());
            
            # check epsg
            self.assertEqual("MGA (GDA 94) UTM Zone 50", cd.getEastNorthProjection()) #gas worked this out from epsg
            self.assertEqual("col3", cd.getEast().getName())
            self.assertEqual("col4", cd.getNorth().getName())

		# TODO Review this exception              
        #except Exception as e:
            #print(f"r ERR {str(e)}" )

        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()

    # test feature select in QGIS will cause feature highlight in Gas
    def test_featureSelect(self):
        testName='test_featureSelect'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  

            # use gateway to start gas
            gasGate.start()
            gasGate.importGasFile(os.path.join("testdata","gis.small.gas"))
            
            # make and select a new red attribute in gas att manager
            atts = gasGate.getChartData().getAttributes()
            red = atts.newColourAttribute();
            red.setName("red");
            atts.setSelectedAttribute(red);
            
            # check that a row is as per the loaded file
            cd = gasGate.getChartData()
            theRows = cd.getRows().getIndexableList()
            self.assertEqual("A", theRows.get(0).getColorAttribute().getName()) # see AA

            # try the client
            glmClient = GasLinkClient_Test(signalling) 
            glmClient.startListener()  
            glmClient.waitForMessages(3)

            # assert gas thinks it has one
            gaslink = gasGate.getGasLink()
            signalling.log(0,testName,f'python client class connected, and (JAVA) SERVER reports gaslink client is {gaslink.getClientName()} ver {gaslink.getClientVersionInt()}')
            self.assertEqual(2006, gasGate.getGasLink().getClientVersionInt())  # 0.2.6 ->2006
            
            # Python side : emulate a user selection event being raised from the GIS layer - eg the first 3 points in the dataset 
            # Ideaslly we achive as per production path through signalling
            #self.signalling.raise_selection_changed([0,1,2]) # int id's passed as a list
            # But for now we just call handler method directly on GLM client
            glmClient.sendGLMApplyAttributes(['0','1','2']) # int id's passed as a list of strings
            glmClient.waitForMessages(1) # 1 or 2?

            
            # java-side check for 3 rows become red
            cd = gasGate.getChartData()
            theRows = cd.getRows().getIndexableList()
            self.assertEqual("red", theRows.get(0).getColorAttribute().getName()) # see AA
            self.assertEqual("red", theRows.get(1).getColorAttribute().getName())
            self.assertEqual("red", theRows.get(2).getColorAttribute().getName())
            self.assertEqual("D", theRows.get(3).getColorAttribute().getName())
            
               
        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()

    # this test is start of:  comparing python and java client timings
	# disabled as boring to wait for
    # you will need 'latest' jar file
    def unused_test_javaClient(self):
        testName='test_javaClient'
        try:
            print(f"\n>>> {testName}")
            signalling = Signalling_Test(testName = testName,silentMode=silentMode)
            gasGate = self.gasGate  
            
            # use gateway to start gas
            signalling.log(0,testName,'starting gas main')
            gasGate.start()

            # connect the JAVA client
            client = gasGate.makeTestClient(GASLINK_PORT, GLM_CLIENT_NAME)
            signalling.log(0,testName,f'--- made  {client}')
            client.connect("0.2", "5")
            signalling.log(0,testName,f'--- conn  {client}')
            
            # connect causes state to get sent (null)
            dataState = client.readAndProcessMessages(1, False);
            self.assertTrue(dataState.isStateNull());

            self.signalling.timer_start('')

            #open new file
            gasGate.importGasFile(os.path.join("testdata","sizetest_100k_65.gas") )

            signalling.timer_stamp('Gas: Data Loaded')

            # first we get told of close that new file causes (null)
            dataState = client.readAndProcessMessages(1, False);
            self.assertTrue(dataState.isStateNull());

            # then another data message, and its a new file
            dataState = client.readAndProcessMessages(1, False);
            self.assertTrue(dataState.isNewFile());
            signalling.timer_stamp('Java Test Client: Data Received')
            signalling.log(0,testName,f'--- got data message {str(dataState)}')
      
            # att message
            attMessage  = client.readAndProcessMessages(1, False);
            signalling.timer_stamp('Java Test Client: Attributes Received')
            signalling.log(0,testName,f'--- got att message {str(attMessage)}')
            
            signalling.log(0,testName,f'{self.signalling.timer_printlog()}')
            
            client.disconnect()
            signalling.log(0,testName,f'Test Client Disconnected')
            
        finally:
            signalling.log(0,testName,'stopping gas main\n')
            gasGate.stop()
    
   
           
def TODO_test_noNorth(self): # WILL NOT RUN AS NOT STARTING WITH TEST
    testName='test_noNorth'
    try:
        print(f"\n>>> {testName}")
        signalling = Signalling_Test(testName = testName,silentMode=silentMode)
        gasGate = self.gasGate  # for convenicne

        # use gateway to start gas
        signalling.log(0,testName,'starting gas main')
        gasGate.start()
        gasGate.importGasFile(os.path.join("testdata","gis.small.no.north.gas"))

        # try the client
        glmClient = GasLinkClient_Test(signalling) 
        glmClient.startListener()  # connect, send GLMConnect, and start listening for messages
        self.assertFalse(True) #fail
        
    # TODO this does not work, as we can't catch error in another thread
    except ValueError as e:
        #initial connection was ok, but we get this error
        self.assertEqual('East and North fields must be set in ioGAS', str(e))

    finally:
        time.sleep(1)

        # use gateway to stop gas, and so stop gaslink server - will do at end of each unit test
        signalling.log(0,testName,'stopping gas main\n')
        x = gasGate.stop()
        time.sleep(1)




def setupGasGate(): # called once for all tests
    try:
        _signalling.log(0,'setupGasGate()',f"TestGasLink - trying to start java 'gasgate', then gas main (with gaslink server) ...")
        # outer build scripts and main method set the path to the jar
        jar = gasjardir + "/libs/GAS.jar" 
        runClass = "net.ioglobal.gas.gaslink.PythonServer"
        _signalling.log(0,'setupGasGate()',f'looking in jar {jar} for {runClass}')

        # py4j server - we have to start the java process, and give it a port to listen on
        childPid = -1
        _signalling.log(0,'setupGasGate()',f"PYTHON setting up gasgate, session id: {sessionId}  appDir: {gasjardir}")

        # comment this line out if using java ide
        arg1 = str(PY4J_PORT)
        arg2 =  sessionId
        arg3 = gasjardir # so some config paths can be found
        proc = subprocess.Popen(['java', '-cp', jar, runClass, arg1, arg2, arg3], universal_newlines=True, close_fds=True)
        try:
            childPid = proc.pid
            _signalling.log(0,'setupGasGate()',f' -  started java process ok id {childPid}')
        except:
            _signalling.log(0,'setupGasGate()',' - unable to start java process')
        time.sleep(0.5)
        
        # now make python py4j 'JavaGateway' (it connects using above port)
        try:
            gateway = JavaGateway(gateway_parameters=GatewayParameters(port=PY4J_PORT))
            time.sleep(0.5)
            if gateway is None:
                _signalling.log(0,'setupGasGate()',' - JavaGateway FAILED TO ESTABLISH()')
            else :
                _signalling.log(0,'setupGasGate()',' - JavaGateway established')
        except:
            _signalling.log(0,'setupGasGate()',' - unable to execute JavaGateway()r\n{traceback.format_exc()}')


        # how to call generic java code, ie not using our entry point class
        ran = gateway.jvm.java.util.Random().nextInt(10)
        _signalling.log(0,'setupGasGate()',f'JAVA random num : {ran}')

        gasGate = gateway.entry_point  # this is the java application passed into the gateway on the java side
        id = gasGate.getSessionId()
        _signalling.log(0,'setupGasGate()',f'JAVA gasgate session id =  {id}')

    except :
        _signalling.log(3,'setupGasGate()', f'ERROR\r\n{traceback.format_exc()}')
    finally:
        _signalling.log(0,'setupGasGate()',"not printing java logs")
        ### dumpJavaLogs()
    return gasGate, childPid,  gateway


def shutdownGasGate(childPid, gateway):
    try:
        # shutdownb the gateway(will do at end of all tests)
        _signalling.log(0,'shutdownGasGate()',f'shutting down gasgate session id {sessionId}')
        gateway.close()
        gateway.shutdown()
        time.sleep(1)
        # the process is still running (at least when I start it from eclipse)
        if childPid != -1:
            _signalling.log(0,'shutdownGasGate()',f'about to kill py4j  server process id =  {childPid}')
            try:
               os.kill(childPid, signal.SIGTERM)
            except:
                _signalling.log(0,'shutdownGasGate()',' - unable to kill')
        else:
            _signalling.log(0,'shutdownGasGate()',f'java process probably in IDE so not killing')
    finally:
        _signalling.log(0,'shutdownGasGate()',"not printing java logs")
        # todo how to stop these interleaving with other stuff if we print
        # dumpJavaLogs()


def dumpJavaLogs():
    print("=== JAVA STDOUT ===")
    with open("PythonServerLog.txt", 'r') as fin:
        print(fin.read())
    print("=== END JAVA STDOUT ===")
    print()


    print("=== JAVA  STDERR ===")
    with open("PythonServerLog.txt", 'r') as fin:
        print(fin.read())
    print("=== END  JAVA  STDERR ===")
    print()






if __name__ == '__main__':
    #IMPORT QT - MUST BE DONE LIKE THIS AS IT DESTROYS THE PATH ENVIRONMENT VARIABLE
    #If you can't find java, that will be because an import has caused PATH to be reset
    
    origPath =os.environ["PATH"]
    #print(f'ORIG  os.environ[path] is {origPath}')

 

    from gaslinkclient_test import GasLinkClient_Test
    
    
    
    evilPath =os.environ["PATH"]
    os.environ["PATH"] = evilPath + ";" + origPath
    newPath =os.environ["PATH"]

    
    
    # Get the command line args we need
    # we must consume the command line arg we want and then COPY
    # the other one for unittest.main()
    gasjardir = sys.argv[1]
    print (f'gasjardir set to {gasjardir}')
    
    # Control output noise in build reporting
    silentMode = int(sys.argv[2])  # 0 for verbose, 1 for silent
    print (f'silentmode set to {silentMode}')
    
    a = [1] # make a new array
    a[0] = sys.argv[0]
    sys.argv = a

    
    _signalling = Signalling_Test(testName = 'main',silentMode=silentMode)
    _signalling.log(0,'main',f'importQT combined os.environ[path] is {newPath}')
        
    # commented out code to test QT imports
    #print('>>>>>>>>>>>about to constr QApp')
    # Create an application global accessible from all tests.
    # app= QApplication( sys.argv )

    # Start the event loop.
    #app.exec_()  # believe this is blocking - runs QT event loop until app quits.
    #print('>>>>>>>>>>>did exec')

    
    # make up a gasgate id (helpful to make sure we are really talking to the java instance we started)
    # needs to be done in main, so that its in scope for test class setup and teardown
    sessionId = str(random.randrange(999999))
    _signalling.log(0,'main',f'made up gasgate (py4j link) session id {sessionId}\n')
    
    # app = QApplication(sys.argv)
    # app.exec_()
    # print('made qapp')
    
    # finally run tests, its what we are here for :)
    unittest.main()

    
