from gaslinkclient_base import GasLinkClient_Base
from gasdata_link import GasData_Link
from gaslinkcomms import GasLinkComms
import gassupport
import os
import threading
import time

LOGFILE = "test.log.messages"


class Signalling_Test(): 

   
    def __init__(self,parent=None,testName="", silentMode=0):
        super().__init__()
        self.MessageReceived = None
        self.testName = testName
        self.silentMode = silentMode # =1 to reduce reporting output during build
        try:
            self.logFile = LOGFILE + "." + self.testName + ".txt"
            os.remove(self.logFile)
        except:
            pass
        
        self.Timer = Timer_Test(self)  # is circular ref a problem?

    def setHandler(self, pHandler):
        self.handler = pHandler
        
    def setParent(self, parent):
        self.Parent = parent
    
        # GIS Selection Changed
        # NOT USED ?
    def raise_selection_changed(self, selFeatures):
        self.slog(f'[Signalling_Test.raise_selection_changed()')
        #self.sig_selection_changed.emit(selFeatures) 
        
    def raise_message_received(self, strMsg):
        #NB This WILL be raised on non-main thread
        self.slog(f'RX {strMsg[0:500]}')
        self.slog('    calling handler in same thread')
        self.handler.on_message_received(strMsg)
        pass 

         # Gas Link connected
    def raise_connected(self):    
        self.slog(f'CONNECTED')
        pass
 
    def raise_listener_exception(self, e):
        #NB This WILL be raised on non-main thread
        self.slog(f'LISTENER EXCEPTION :\n {e.args}')
        pass
        
    def raise_connection_lost(self):
        #NB This WILL be raised on non-main thread
        self.slog(f'CONNECTION LOST')
        self.slog('    calling handler in same thread')
        self.handler.on_connection_lost()
        pass
    
    def slog(self, msg):
        self.log(1, f"TST {self.testName}", msg)
          
    def log(self, loglevel,source,msg):
        #NB This MAY be raised on non-main thread
        tid = threading.get_ident()
        mm = f'LOG Thr{tid} [{source}] {msg}'
        
        if self.silentMode != 1:  # if not in silent mode then also print to std out
            print(mm)
            
        try:
            fileL = open(self.logFile,"a") 
            fileL.write(mm + '\n')
            fileL.close()
        except:
            print("log file error")
            

    def notify(self, level,msg):
        #NB This MAY be raised on non-main thread
        self.slog(f'UI {strMsg}')
        
     # timer signals 
    def timer_start(self, strMsg=None):
        self.Timer.start(strMsg)
        
    def timer_stamp(self, strMsg=None):
        self.Timer.stamp(strMsg)
        
    def timer_printlog(self, strMsg=None):
        return self.Timer.printlog(strMsg)         
    
    def timer_stop(self, strMsg=None):
        self.Timer.stop(strMsg)            


        
# simple timer class for tracking performance

class Timer_Test:
    
    def __init__(self,pSignalling):
        self.signalling = pSignalling         
        self.log = '' # keep track of timing messages, view on stop
        self.start_time = None
        self.prev_time = None

    def start(self,msg=''):
        if self.start_time is not None:
            self.stamp(msg + '(Timer Starting)') # just stamp if already running

        self.log = ''
        self.start_time = time.perf_counter()
        self.prev_time= self.start_time
        self.stamp(msg + '(Timer Starting)')

    def stamp(self,msg=''):
        if self.start_time is None:
            self.start(msg) # auto start if req'd on first stamp
            
        elapsed_time = time.perf_counter() - self.start_time
        prev_elapsed_time = time.perf_counter() - self.prev_time          
        self.log = f'{self.log }\r\n[{elapsed_time:0.4f}][{prev_elapsed_time:0.4f}]:{msg}'
        self.prev_time = time.perf_counter()
    
    def printlog(self,msg=''):
        self.signalling.slog(f'TIMER: {self.log}')
        return self.log
     
    def stop(self,msg=''):
        self.stamp(msg + ' (Timer Stopping)')
        self.start_time = None
        self.prev_time = None
        self.signalling.slog(f'TIMER:{self.log}')

