import sys
import os
from pathlib import Path

import configparser
from enum import Enum, auto

from qgis.PyQt.QtCore import *

try:
    from ioGAS.gassupport import *
except:
    from gassupport import *
    
# Signalling (thread-safe) - and logging
# We use QT signals to allow marshalling of notfications and events between objects esp those that maybe on a seperate thread.
class Signalling_App(QObject):

    # Declare Signals - equiv to a raisable 'event'
    sig_log_raised = pyqtSignal(object,object,object,object)   # a Signal for raising signalling messages
    sig_notify_raised = pyqtSignal(object,object,object)              # a Signal for raising UI notification messages
    
    # GLM Comms & TCP/IP signals
    sig_message_received = pyqtSignal(object)   
    sig_connection_lost = pyqtSignal()
    sig_user_cancelled = pyqtSignal()     
    sig_connected = pyqtSignal()
    sig_listener_exception = pyqtSignal(object)       

    sig_selection_changed = pyqtSignal(object)     
          
    sig_timer_start = pyqtSignal(object) 
    sig_timer_stamp = pyqtSignal(object) 
    sig_timer_stop = pyqtSignal(object) 
    sig_timer_printlog = pyqtSignal(object) 
    
    def __init__(self):
        super().__init__() # reparent me 
     
        self.Timer = Timer(self)  # is circular ref a problem ?
           
# These public wrapper methods will publish via the signals  
   
    # GIS Selection Changed
    def raise_selection_changed(self, selFeatures):
        self.sig_selection_changed.emit(selFeatures) 
        
    # GLM message 
    def raise_message_received(self, strMsg):
        self.sig_message_received.emit(strMsg) 
    
     # Link connected
    def raise_connected(self):
        self.sig_connected.emit() 

    def raise_listener_exception(self,e):
        self.sig_listener_exception.emit(e) 
        
    # lost Gas Link
    def raise_connection_lost(self):
        self.sig_connection_lost.emit() 
        
    # User Cancelled
    def raise_user_cancelled(self):
        self.sig_user_cancelled.emit() 
             
    # log message
    def log(self, loglevel,source,msg):
        self.sig_log_raised.emit(threading.current_thread().name,loglevel,source,msg) # raise the message received signal
        
    # UI notification     
    def notify(self, level,msg):
        self.sig_notify_raised.emit(threading.current_thread().name,level,msg) 
    
       
    # timer signals 
    def timer_start(self, strMsg=None):
        self.sig_timer_start.emit(strMsg)
        
    def timer_stamp(self, strMsg=None):
        self.sig_timer_stamp.emit(strMsg)
        
    def timer_printlog(self, strMsg=None):
        self.sig_timer_printlog.emit(strMsg)         
    
    def timer_stop(self, strMsg=None):
        self.sig_timer_stop.emit(strMsg)            
        