import sys
import os
from pathlib import Path
import tempfile

import threading 
import socket
from io import StringIO

from time import sleep
import configparser


from gaslinkclient_base import GasLinkClient_Base
from gasdata_link import GasData_Link
from gaslinkcomms import GasLinkComms
import gassupport
import gaslink
import gas


class GasLinkClient_Test(GasLinkClient_Base ):

    def __init__(self, pSignalling, pClientName=GasLinkClient_Base.CLIENT_TYPE, pHangTesting = False):  
        # make a mock signalling and pass up
        self.config, msg = gassupport.read_or_initialise_config()
        super().__init__(pSignalling, self.config, pClientName, pHangTesting)
        
        self.signalling.log(0,'GasLinkClient_Test.init()','constructing GasLinkClient_Test')

        self.TestLog = ''  # property to record test data
    
        # wire up the mock signalling
        self.signalling.setHandler(self)
        
        self.logFilePath = gassupport.get_logfile_path(True)
        self.signalling.log(3,'GasLinkClient_Test.init()', f'Logging to : \n{self.logFilePath}')

        # setup data storage, and connection (base class)
        self.setup()
        
    # Display the new/refreshed data (stub only)   
    def display_data(self, datavalid):
        self.signalling.log(2,'GasLinkClient_Test.display_data()',f'DOING NOTHING')
        
    def setTestViews(self, pTestViews):
        self.viewList = pTestViews
        
    def setTestEpsg(self, pEpsg):
        self.epsg = pEpsg
        
    def setTestEast(self, pEast):
        self.east = pEast
        
    def setTestNorth(self, pNorth):
        self.north = pNorth
        
    def getViewList(self):
        return self.viewList

# build a GLMGetDataDone message from the named qgis layer
    def getDataMessage(self, layerName):
        g = gaslink.GLMGetDataDone()
    
        g.set_stateNull(False)
        self.signalling.log(1,'GasLinkClient_Test.sendGLMGetDataDone()', 'state null set false')
        sc = gas.xSpecialColumns()
        g.set_specialColumns(sc)
        

        # setup columns
        cols = gas.xColumns()
        
        
        # set special cols
        sc.set_map_epsg(self.epsg) #dummy test vals
        sc.set_map_east(self.east)
        sc.set_map_north(self.north)
        
        col = gas.xColumn()
        col.set_aliasName("col1")
        col.set_origonalName("orig.col1")
        col.set_type("Numeric")
        cols.add_column(col)

        
        col = gas.xColumn()
        col.set_aliasName("col2")
        col.set_origonalName("orig.col2")
        col.set_type("Numeric")
        cols.add_column(col)

        col = gas.xColumn()
        col.set_aliasName("col3")
        col.set_origonalName("orig.col3")
        col.set_type("Numeric")
        cols.add_column(col)

        col = gas.xColumn()
        col.set_aliasName("col4")
        col.set_origonalName("orig.col4")
        col.set_type("Numeric")
        cols.add_column(col)

        g.set_columns(cols)
        
        
        #setup rows
        rows = gas.xDRs()
        
        row = gas.xDR()
        row.set_valueOf_("1,2,3,4")
        rows.add_DR(row)
        
        row = gas.xDR()
        row.set_valueOf_("5,6,7,8")
        rows.add_DR(row)
        
        g.set_DRs(rows)
        
        return g
         
  
  # RW do not override, let the real handler in the base do its job
    # def handle_message_received(self,strMsg):
  
 
