#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Fri Jun 28 17:23:22 2024 by generateDS.py version 2.35.7.
# Python 3.7.4 (default, Aug  9 2019, 18:34:13) [MSC v.1915 64 bit (AMD64)]
#
# Command line options:
#   ('-f', '')
#   ('-o', 'gaslink.py')
#
# Command line arguments:
#   ../src/resources/net/ioglobal/gas/gaslink/messages/gaslink.xsd
#
# Command line:
#   c:/generateDS-2.35.7/generateDS.py -f -o "gaslink.py" ../src/resources/net/ioglobal/gas/gaslink/messages/gaslink.xsd
#
# Current working directory (os.getcwd()):
#   gaslink.python
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return ('%0.10f' % input_data).rstrip('0')
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class Protocol(GeneratedsSuper):
    """Not a message. Contains a constant that allows code to get a string that
    is the version of the protocol.
    The version string of the protocol. The client
    and ioGAS must use the same version."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Version='0.2', MinorVersion='6', gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Version = _cast(None, Version)
        self.Version_nsprefix_ = None
        self.MinorVersion = _cast(None, MinorVersion)
        self.MinorVersion_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Protocol)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Protocol.subclass:
            return Protocol.subclass(*args_, **kwargs_)
        else:
            return Protocol(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Version(self):
        return self.Version
    def set_Version(self, Version):
        self.Version = Version
    def get_MinorVersion(self):
        return self.MinorVersion
    def set_MinorVersion(self, MinorVersion):
        self.MinorVersion = MinorVersion
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Protocol', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Protocol')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Protocol')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Protocol', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Protocol'):
        if self.Version != "0.2" and 'Version' not in already_processed:
            already_processed.add('Version')
            outfile.write(' Version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.Version), input_name='Version')), ))
        if self.MinorVersion != "6" and 'MinorVersion' not in already_processed:
            already_processed.add('MinorVersion')
            outfile.write(' MinorVersion=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.MinorVersion), input_name='MinorVersion')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Protocol', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Version', node)
        if value is not None and 'Version' not in already_processed:
            already_processed.add('Version')
            self.Version = value
        value = find_attr_value_('MinorVersion', node)
        if value is not None and 'MinorVersion' not in already_processed:
            already_processed.add('MinorVersion')
            self.MinorVersion = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class Protocol


class GLMConnect(GeneratedsSuper):
    """Message to ioGAS to initiate a new client connection. Must be done prior
    to any messages being exchanged. ioGAS will only accept connections
    from one client at a time.
    Client Name. This is a key to allow the Link to
    be used, and may also appear in gas GUI
    This is the protocol major version being used. A
    server will reject the connection if this is
    does not match.
    This is the protocol minor version being used."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, clientType=None, protocolVersion=None, protocolMinorVersion=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.clientType = _cast(None, clientType)
        self.clientType_nsprefix_ = None
        self.protocolVersion = _cast(None, protocolVersion)
        self.protocolVersion_nsprefix_ = None
        self.protocolMinorVersion = _cast(None, protocolMinorVersion)
        self.protocolMinorVersion_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMConnect)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMConnect.subclass:
            return GLMConnect.subclass(*args_, **kwargs_)
        else:
            return GLMConnect(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_clientType(self):
        return self.clientType
    def set_clientType(self, clientType):
        self.clientType = clientType
    def get_protocolVersion(self):
        return self.protocolVersion
    def set_protocolVersion(self, protocolVersion):
        self.protocolVersion = protocolVersion
    def get_protocolMinorVersion(self):
        return self.protocolMinorVersion
    def set_protocolMinorVersion(self, protocolMinorVersion):
        self.protocolMinorVersion = protocolMinorVersion
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMConnect', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMConnect')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMConnect')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMConnect', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMConnect'):
        if self.clientType is not None and 'clientType' not in already_processed:
            already_processed.add('clientType')
            outfile.write(' clientType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.clientType), input_name='clientType')), ))
        if self.protocolVersion is not None and 'protocolVersion' not in already_processed:
            already_processed.add('protocolVersion')
            outfile.write(' protocolVersion=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.protocolVersion), input_name='protocolVersion')), ))
        if self.protocolMinorVersion is not None and 'protocolMinorVersion' not in already_processed:
            already_processed.add('protocolMinorVersion')
            outfile.write(' protocolMinorVersion=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.protocolMinorVersion), input_name='protocolMinorVersion')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMConnect', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('clientType', node)
        if value is not None and 'clientType' not in already_processed:
            already_processed.add('clientType')
            self.clientType = value
        value = find_attr_value_('protocolVersion', node)
        if value is not None and 'protocolVersion' not in already_processed:
            already_processed.add('protocolVersion')
            self.protocolVersion = value
        value = find_attr_value_('protocolMinorVersion', node)
        if value is not None and 'protocolMinorVersion' not in already_processed:
            already_processed.add('protocolMinorVersion')
            self.protocolMinorVersion = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMConnect


class GLMConnectDone(GeneratedsSuper):
    """Message from ioGAS to indicate the result of the connection request.
    True only if the connection succeeded (the
    client type and protocol version are correct).
    The major version of the protocol the server is using. Clients must use the
    same version.The minor version of the protocol the server is using.
    A user-friendly (error) message if applicable."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, connectionOK=None, ServerVersion=None, ServerMinorVersion=None, description=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.connectionOK = _cast(bool, connectionOK)
        self.connectionOK_nsprefix_ = None
        self.ServerVersion = _cast(None, ServerVersion)
        self.ServerVersion_nsprefix_ = None
        self.ServerMinorVersion = _cast(None, ServerMinorVersion)
        self.ServerMinorVersion_nsprefix_ = None
        self.description = _cast(None, description)
        self.description_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMConnectDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMConnectDone.subclass:
            return GLMConnectDone.subclass(*args_, **kwargs_)
        else:
            return GLMConnectDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_connectionOK(self):
        return self.connectionOK
    def set_connectionOK(self, connectionOK):
        self.connectionOK = connectionOK
    def get_ServerVersion(self):
        return self.ServerVersion
    def set_ServerVersion(self, ServerVersion):
        self.ServerVersion = ServerVersion
    def get_ServerMinorVersion(self):
        return self.ServerMinorVersion
    def set_ServerMinorVersion(self, ServerMinorVersion):
        self.ServerMinorVersion = ServerMinorVersion
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMConnectDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMConnectDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMConnectDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMConnectDone', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMConnectDone'):
        if self.connectionOK is not None and 'connectionOK' not in already_processed:
            already_processed.add('connectionOK')
            outfile.write(' connectionOK="%s"' % self.gds_format_boolean(self.connectionOK, input_name='connectionOK'))
        if self.ServerVersion is not None and 'ServerVersion' not in already_processed:
            already_processed.add('ServerVersion')
            outfile.write(' ServerVersion=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ServerVersion), input_name='ServerVersion')), ))
        if self.ServerMinorVersion is not None and 'ServerMinorVersion' not in already_processed:
            already_processed.add('ServerMinorVersion')
            outfile.write(' ServerMinorVersion=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ServerMinorVersion), input_name='ServerMinorVersion')), ))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            outfile.write(' description=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.description), input_name='description')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMConnectDone', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('connectionOK', node)
        if value is not None and 'connectionOK' not in already_processed:
            already_processed.add('connectionOK')
            if value in ('true', '1'):
                self.connectionOK = True
            elif value in ('false', '0'):
                self.connectionOK = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ServerVersion', node)
        if value is not None and 'ServerVersion' not in already_processed:
            already_processed.add('ServerVersion')
            self.ServerVersion = value
        value = find_attr_value_('ServerMinorVersion', node)
        if value is not None and 'ServerMinorVersion' not in already_processed:
            already_processed.add('ServerMinorVersion')
            self.ServerMinorVersion = value
        value = find_attr_value_('description', node)
        if value is not None and 'description' not in already_processed:
            already_processed.add('description')
            self.description = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMConnectDone


class GLMPing(GeneratedsSuper):
    """A message in either direction purely to test the status of the
    link.unused"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(bool, dummy)
        self.dummy_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMPing)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMPing.subclass:
            return GLMPing.subclass(*args_, **kwargs_)
        else:
            return GLMPing(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMPing', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMPing')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMPing')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMPing', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMPing'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_boolean(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMPing', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            if value in ('true', '1'):
                self.dummy = True
            elif value in ('false', '0'):
                self.dummy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMPing


class GLMPingDone(GeneratedsSuper):
    """A response to confirm the link is alive.unused"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(bool, dummy)
        self.dummy_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMPingDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMPingDone.subclass:
            return GLMPingDone.subclass(*args_, **kwargs_)
        else:
            return GLMPingDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMPingDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMPingDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMPingDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMPingDone', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMPingDone'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_boolean(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMPingDone', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            if value in ('true', '1'):
                self.dummy = True
            elif value in ('false', '0'):
                self.dummy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMPingDone


class GLMApplyAttributes(GeneratedsSuper):
    """Message to ioGAS to apply attribute state. This defines all of the
    shape, colour, size and filter attributes, and also all 4 attributes
    for each row.
    If true the gas attribute manager selection stat is used.
    If false new attributes are made, named, and
    used, according to the newColourName etc.
    The name for a new colour attribute that should be applied to the rows.
    All existing colours are cleared firstThe name for a new shape attribute
    that should be applied to the rows.
    All existing shapes are cleared firstThe name for a new size attribute that
    should be applied to the rows.
    All existing sizes are cleared firstThe name for a new filter attribute
    that should be applied to the rows.
    All existing filters are cleared first"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, useGasState=None, newColourName=None, clearColours=None, newShapeName=None, clearShapes=None, newSizeName=None, clearSizes=None, newFilterName=None, clearFilters=None, rowIDs=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.useGasState = _cast(bool, useGasState)
        self.useGasState_nsprefix_ = None
        self.newColourName = _cast(None, newColourName)
        self.newColourName_nsprefix_ = None
        self.clearColours = _cast(bool, clearColours)
        self.clearColours_nsprefix_ = None
        self.newShapeName = _cast(None, newShapeName)
        self.newShapeName_nsprefix_ = None
        self.clearShapes = _cast(bool, clearShapes)
        self.clearShapes_nsprefix_ = None
        self.newSizeName = _cast(None, newSizeName)
        self.newSizeName_nsprefix_ = None
        self.clearSizes = _cast(bool, clearSizes)
        self.clearSizes_nsprefix_ = None
        self.newFilterName = _cast(None, newFilterName)
        self.newFilterName_nsprefix_ = None
        self.clearFilters = _cast(bool, clearFilters)
        self.clearFilters_nsprefix_ = None
        self.rowIDs = rowIDs
        self.rowIDs_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMApplyAttributes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMApplyAttributes.subclass:
            return GLMApplyAttributes.subclass(*args_, **kwargs_)
        else:
            return GLMApplyAttributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_rowIDs(self):
        return self.rowIDs
    def set_rowIDs(self, rowIDs):
        self.rowIDs = rowIDs
    def get_useGasState(self):
        return self.useGasState
    def set_useGasState(self, useGasState):
        self.useGasState = useGasState
    def get_newColourName(self):
        return self.newColourName
    def set_newColourName(self, newColourName):
        self.newColourName = newColourName
    def get_clearColours(self):
        return self.clearColours
    def set_clearColours(self, clearColours):
        self.clearColours = clearColours
    def get_newShapeName(self):
        return self.newShapeName
    def set_newShapeName(self, newShapeName):
        self.newShapeName = newShapeName
    def get_clearShapes(self):
        return self.clearShapes
    def set_clearShapes(self, clearShapes):
        self.clearShapes = clearShapes
    def get_newSizeName(self):
        return self.newSizeName
    def set_newSizeName(self, newSizeName):
        self.newSizeName = newSizeName
    def get_clearSizes(self):
        return self.clearSizes
    def set_clearSizes(self, clearSizes):
        self.clearSizes = clearSizes
    def get_newFilterName(self):
        return self.newFilterName
    def set_newFilterName(self, newFilterName):
        self.newFilterName = newFilterName
    def get_clearFilters(self):
        return self.clearFilters
    def set_clearFilters(self, clearFilters):
        self.clearFilters = clearFilters
    def hasContent_(self):
        if (
            self.rowIDs is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMApplyAttributes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMApplyAttributes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMApplyAttributes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMApplyAttributes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMApplyAttributes'):
        if self.useGasState is not None and 'useGasState' not in already_processed:
            already_processed.add('useGasState')
            outfile.write(' useGasState="%s"' % self.gds_format_boolean(self.useGasState, input_name='useGasState'))
        if self.newColourName is not None and 'newColourName' not in already_processed:
            already_processed.add('newColourName')
            outfile.write(' newColourName=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.newColourName), input_name='newColourName')), ))
        if self.clearColours is not None and 'clearColours' not in already_processed:
            already_processed.add('clearColours')
            outfile.write(' clearColours="%s"' % self.gds_format_boolean(self.clearColours, input_name='clearColours'))
        if self.newShapeName is not None and 'newShapeName' not in already_processed:
            already_processed.add('newShapeName')
            outfile.write(' newShapeName=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.newShapeName), input_name='newShapeName')), ))
        if self.clearShapes is not None and 'clearShapes' not in already_processed:
            already_processed.add('clearShapes')
            outfile.write(' clearShapes="%s"' % self.gds_format_boolean(self.clearShapes, input_name='clearShapes'))
        if self.newSizeName is not None and 'newSizeName' not in already_processed:
            already_processed.add('newSizeName')
            outfile.write(' newSizeName=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.newSizeName), input_name='newSizeName')), ))
        if self.clearSizes is not None and 'clearSizes' not in already_processed:
            already_processed.add('clearSizes')
            outfile.write(' clearSizes="%s"' % self.gds_format_boolean(self.clearSizes, input_name='clearSizes'))
        if self.newFilterName is not None and 'newFilterName' not in already_processed:
            already_processed.add('newFilterName')
            outfile.write(' newFilterName=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.newFilterName), input_name='newFilterName')), ))
        if self.clearFilters is not None and 'clearFilters' not in already_processed:
            already_processed.add('clearFilters')
            outfile.write(' clearFilters="%s"' % self.gds_format_boolean(self.clearFilters, input_name='clearFilters'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMApplyAttributes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.rowIDs is not None:
            namespaceprefix_ = self.rowIDs_nsprefix_ + ':' if (UseCapturedNS_ and self.rowIDs_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srowIDs>%s</%srowIDs>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.rowIDs), input_name='rowIDs')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('useGasState', node)
        if value is not None and 'useGasState' not in already_processed:
            already_processed.add('useGasState')
            if value in ('true', '1'):
                self.useGasState = True
            elif value in ('false', '0'):
                self.useGasState = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('newColourName', node)
        if value is not None and 'newColourName' not in already_processed:
            already_processed.add('newColourName')
            self.newColourName = value
        value = find_attr_value_('clearColours', node)
        if value is not None and 'clearColours' not in already_processed:
            already_processed.add('clearColours')
            if value in ('true', '1'):
                self.clearColours = True
            elif value in ('false', '0'):
                self.clearColours = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('newShapeName', node)
        if value is not None and 'newShapeName' not in already_processed:
            already_processed.add('newShapeName')
            self.newShapeName = value
        value = find_attr_value_('clearShapes', node)
        if value is not None and 'clearShapes' not in already_processed:
            already_processed.add('clearShapes')
            if value in ('true', '1'):
                self.clearShapes = True
            elif value in ('false', '0'):
                self.clearShapes = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('newSizeName', node)
        if value is not None and 'newSizeName' not in already_processed:
            already_processed.add('newSizeName')
            self.newSizeName = value
        value = find_attr_value_('clearSizes', node)
        if value is not None and 'clearSizes' not in already_processed:
            already_processed.add('clearSizes')
            if value in ('true', '1'):
                self.clearSizes = True
            elif value in ('false', '0'):
                self.clearSizes = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('newFilterName', node)
        if value is not None and 'newFilterName' not in already_processed:
            already_processed.add('newFilterName')
            self.newFilterName = value
        value = find_attr_value_('clearFilters', node)
        if value is not None and 'clearFilters' not in already_processed:
            already_processed.add('clearFilters')
            if value in ('true', '1'):
                self.clearFilters = True
            elif value in ('false', '0'):
                self.clearFilters = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'rowIDs':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'rowIDs')
            value_ = self.gds_validate_string(value_, node, 'rowIDs')
            self.rowIDs = value_
            self.rowIDs_nsprefix_ = child_.prefix
# end class GLMApplyAttributes


class GLMApplyAttributesDone(GeneratedsSuper):
    """Message from ioGAS to indicate completion"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(bool, dummy)
        self.dummy_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMApplyAttributesDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMApplyAttributesDone.subclass:
            return GLMApplyAttributesDone.subclass(*args_, **kwargs_)
        else:
            return GLMApplyAttributesDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMApplyAttributesDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMApplyAttributesDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMApplyAttributesDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMApplyAttributesDone', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMApplyAttributesDone'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_boolean(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMApplyAttributesDone', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            if value in ('true', '1'):
                self.dummy = True
            elif value in ('false', '0'):
                self.dummy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMApplyAttributesDone


class GLMAddColumn(GeneratedsSuper):
    """Message to ioGAS to add a new columnThe name of the column to be added.
    column type, must be one of Text or Numeric"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, type_=None, columnData=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.type_ = _cast(None, type_)
        self.type__nsprefix_ = None
        self.columnData = columnData
        self.columnData_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMAddColumn)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMAddColumn.subclass:
            return GLMAddColumn.subclass(*args_, **kwargs_)
        else:
            return GLMAddColumn(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_columnData(self):
        return self.columnData
    def set_columnData(self, columnData):
        self.columnData = columnData
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def hasContent_(self):
        if (
            self.columnData is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMAddColumn', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMAddColumn')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMAddColumn')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMAddColumn', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMAddColumn'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMAddColumn', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.columnData is not None:
            namespaceprefix_ = self.columnData_nsprefix_ + ':' if (UseCapturedNS_ and self.columnData_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scolumnData>%s</%scolumnData>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.columnData), input_name='columnData')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'columnData':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'columnData')
            value_ = self.gds_validate_string(value_, node, 'columnData')
            self.columnData = value_
            self.columnData_nsprefix_ = child_.prefix
# end class GLMAddColumn


class GLMAddColumnDone(GeneratedsSuper):
    """Message from ioGAS to indicate completionUnused"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(bool, dummy)
        self.dummy_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMAddColumnDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMAddColumnDone.subclass:
            return GLMAddColumnDone.subclass(*args_, **kwargs_)
        else:
            return GLMAddColumnDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMAddColumnDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMAddColumnDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMAddColumnDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMAddColumnDone', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMAddColumnDone'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_boolean(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMAddColumnDone', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            if value in ('true', '1'):
                self.dummy = True
            elif value in ('false', '0'):
                self.dummy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMAddColumnDone


class GLMSendAttributes(GeneratedsSuper):
    """Message from ioGAS to update the client with all current attribute
    state."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, colourAttributes=None, shapeAttributes=None, sizeAttributes=None, filterAttributes=None, rows=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.colourAttributes = colourAttributes
        self.colourAttributes_nsprefix_ = None
        self.shapeAttributes = shapeAttributes
        self.shapeAttributes_nsprefix_ = None
        self.sizeAttributes = sizeAttributes
        self.sizeAttributes_nsprefix_ = None
        self.filterAttributes = filterAttributes
        self.filterAttributes_nsprefix_ = None
        self.rows = rows
        self.rows_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMSendAttributes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMSendAttributes.subclass:
            return GLMSendAttributes.subclass(*args_, **kwargs_)
        else:
            return GLMSendAttributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_colourAttributes(self):
        return self.colourAttributes
    def set_colourAttributes(self, colourAttributes):
        self.colourAttributes = colourAttributes
    def get_shapeAttributes(self):
        return self.shapeAttributes
    def set_shapeAttributes(self, shapeAttributes):
        self.shapeAttributes = shapeAttributes
    def get_sizeAttributes(self):
        return self.sizeAttributes
    def set_sizeAttributes(self, sizeAttributes):
        self.sizeAttributes = sizeAttributes
    def get_filterAttributes(self):
        return self.filterAttributes
    def set_filterAttributes(self, filterAttributes):
        self.filterAttributes = filterAttributes
    def get_rows(self):
        return self.rows
    def set_rows(self, rows):
        self.rows = rows
    def hasContent_(self):
        if (
            self.colourAttributes is not None or
            self.shapeAttributes is not None or
            self.sizeAttributes is not None or
            self.filterAttributes is not None or
            self.rows is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendAttributes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMSendAttributes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMSendAttributes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMSendAttributes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMSendAttributes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendAttributes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.colourAttributes is not None:
            namespaceprefix_ = self.colourAttributes_nsprefix_ + ':' if (UseCapturedNS_ and self.colourAttributes_nsprefix_) else ''
            self.colourAttributes.export(outfile, level, namespaceprefix_, namespacedef_='', name_='colourAttributes', pretty_print=pretty_print)
        if self.shapeAttributes is not None:
            namespaceprefix_ = self.shapeAttributes_nsprefix_ + ':' if (UseCapturedNS_ and self.shapeAttributes_nsprefix_) else ''
            self.shapeAttributes.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shapeAttributes', pretty_print=pretty_print)
        if self.sizeAttributes is not None:
            namespaceprefix_ = self.sizeAttributes_nsprefix_ + ':' if (UseCapturedNS_ and self.sizeAttributes_nsprefix_) else ''
            self.sizeAttributes.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sizeAttributes', pretty_print=pretty_print)
        if self.filterAttributes is not None:
            namespaceprefix_ = self.filterAttributes_nsprefix_ + ':' if (UseCapturedNS_ and self.filterAttributes_nsprefix_) else ''
            self.filterAttributes.export(outfile, level, namespaceprefix_, namespacedef_='', name_='filterAttributes', pretty_print=pretty_print)
        if self.rows is not None:
            namespaceprefix_ = self.rows_nsprefix_ + ':' if (UseCapturedNS_ and self.rows_nsprefix_) else ''
            self.rows.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rows', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'colourAttributes':
            obj_ = xColourAttributes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.colourAttributes = obj_
            obj_.original_tagname_ = 'colourAttributes'
        elif nodeName_ == 'shapeAttributes':
            obj_ = xShapeAttributes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shapeAttributes = obj_
            obj_.original_tagname_ = 'shapeAttributes'
        elif nodeName_ == 'sizeAttributes':
            obj_ = xSizeAttributes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sizeAttributes = obj_
            obj_.original_tagname_ = 'sizeAttributes'
        elif nodeName_ == 'filterAttributes':
            obj_ = xFilterAttributes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.filterAttributes = obj_
            obj_.original_tagname_ = 'filterAttributes'
        elif nodeName_ == 'rows':
            obj_ = xRows.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.rows = obj_
            obj_.original_tagname_ = 'rows'
# end class GLMSendAttributes


class GLMSendAttributesDone(GeneratedsSuper):
    """Message to ioGAS to indicate the attributes have been applied (ioGAS may
    not wait for this message)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(bool, dummy)
        self.dummy_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMSendAttributesDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMSendAttributesDone.subclass:
            return GLMSendAttributesDone.subclass(*args_, **kwargs_)
        else:
            return GLMSendAttributesDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendAttributesDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMSendAttributesDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMSendAttributesDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMSendAttributesDone', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMSendAttributesDone'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_boolean(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendAttributesDone', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            if value in ('true', '1'):
                self.dummy = True
            elif value in ('false', '0'):
                self.dummy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMSendAttributesDone


class GLMSendData(GeneratedsSuper):
    """Message from ioGAS. This is sent by gas when the loaded data changes in
    any way.
    The format is the same as the GLMGetDataDone message, and the documentation
    is there.True if gas has no data loaded.The name for the loaded data
    (eg filename).True is the data is a new file, or if the structure (row
    and column count) has changed. If it is false then data cells may have
    changed value, but the row and column counts are unchanged."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, stateNull=None, name=None, newFile=None, specialColumns=None, columns=None, DRs=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.stateNull = _cast(bool, stateNull)
        self.stateNull_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.newFile = _cast(bool, newFile)
        self.newFile_nsprefix_ = None
        self.specialColumns = specialColumns
        self.specialColumns_nsprefix_ = None
        self.columns = columns
        self.columns_nsprefix_ = None
        self.DRs = DRs
        self.DRs_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMSendData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMSendData.subclass:
            return GLMSendData.subclass(*args_, **kwargs_)
        else:
            return GLMSendData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_specialColumns(self):
        return self.specialColumns
    def set_specialColumns(self, specialColumns):
        self.specialColumns = specialColumns
    def get_columns(self):
        return self.columns
    def set_columns(self, columns):
        self.columns = columns
    def get_DRs(self):
        return self.DRs
    def set_DRs(self, DRs):
        self.DRs = DRs
    def get_stateNull(self):
        return self.stateNull
    def set_stateNull(self, stateNull):
        self.stateNull = stateNull
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_newFile(self):
        return self.newFile
    def set_newFile(self, newFile):
        self.newFile = newFile
    def hasContent_(self):
        if (
            self.specialColumns is not None or
            self.columns is not None or
            self.DRs is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendData', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMSendData')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMSendData')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMSendData', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMSendData'):
        if self.stateNull is not None and 'stateNull' not in already_processed:
            already_processed.add('stateNull')
            outfile.write(' stateNull="%s"' % self.gds_format_boolean(self.stateNull, input_name='stateNull'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.newFile is not None and 'newFile' not in already_processed:
            already_processed.add('newFile')
            outfile.write(' newFile="%s"' % self.gds_format_boolean(self.newFile, input_name='newFile'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendData', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.specialColumns is not None:
            namespaceprefix_ = self.specialColumns_nsprefix_ + ':' if (UseCapturedNS_ and self.specialColumns_nsprefix_) else ''
            self.specialColumns.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specialColumns', pretty_print=pretty_print)
        if self.columns is not None:
            namespaceprefix_ = self.columns_nsprefix_ + ':' if (UseCapturedNS_ and self.columns_nsprefix_) else ''
            self.columns.export(outfile, level, namespaceprefix_, namespacedef_='', name_='columns', pretty_print=pretty_print)
        if self.DRs is not None:
            namespaceprefix_ = self.DRs_nsprefix_ + ':' if (UseCapturedNS_ and self.DRs_nsprefix_) else ''
            self.DRs.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DRs', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('stateNull', node)
        if value is not None and 'stateNull' not in already_processed:
            already_processed.add('stateNull')
            if value in ('true', '1'):
                self.stateNull = True
            elif value in ('false', '0'):
                self.stateNull = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('newFile', node)
        if value is not None and 'newFile' not in already_processed:
            already_processed.add('newFile')
            if value in ('true', '1'):
                self.newFile = True
            elif value in ('false', '0'):
                self.newFile = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'specialColumns':
            obj_ = xSpecialColumns.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specialColumns = obj_
            obj_.original_tagname_ = 'specialColumns'
        elif nodeName_ == 'columns':
            obj_ = xColumns.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.columns = obj_
            obj_.original_tagname_ = 'columns'
        elif nodeName_ == 'DRs':
            obj_ = xDRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DRs = obj_
            obj_.original_tagname_ = 'DRs'
# end class GLMSendData


class GLMSendDataDone(GeneratedsSuper):
    """Message to ioGAS to indicate the data has been received (ioGAS may not
    wait for this message)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(bool, dummy)
        self.dummy_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMSendDataDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMSendDataDone.subclass:
            return GLMSendDataDone.subclass(*args_, **kwargs_)
        else:
            return GLMSendDataDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendDataDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMSendDataDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMSendDataDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMSendDataDone', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMSendDataDone'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_boolean(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMSendDataDone', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            if value in ('true', '1'):
                self.dummy = True
            elif value in ('false', '0'):
                self.dummy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMSendDataDone


class GLMGetViewList(GeneratedsSuper):
    """Message from ioGAS to request the list of views that the client can
    provide (ie the names of them).unused"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(bool, dummy)
        self.dummy_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMGetViewList)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMGetViewList.subclass:
            return GLMGetViewList.subclass(*args_, **kwargs_)
        else:
            return GLMGetViewList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetViewList', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMGetViewList')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMGetViewList')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMGetViewList', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMGetViewList'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_boolean(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetViewList', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            if value in ('true', '1'):
                self.dummy = True
            elif value in ('false', '0'):
                self.dummy = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMGetViewList


class GLMGetViewListDone(GeneratedsSuper):
    """Message to ioGAS to return the list of view names."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, view=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if view is None:
            self.view = []
        else:
            self.view = view
        self.view_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMGetViewListDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMGetViewListDone.subclass:
            return GLMGetViewListDone.subclass(*args_, **kwargs_)
        else:
            return GLMGetViewListDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_view(self):
        return self.view
    def set_view(self, view):
        self.view = view
    def add_view(self, value):
        self.view.append(value)
    def insert_view_at(self, index, value):
        self.view.insert(index, value)
    def replace_view_at(self, index, value):
        self.view[index] = value
    def hasContent_(self):
        if (
            self.view
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetViewListDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMGetViewListDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMGetViewListDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMGetViewListDone', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMGetViewListDone'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetViewListDone', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for view_ in self.view:
            namespaceprefix_ = self.view_nsprefix_ + ':' if (UseCapturedNS_ and self.view_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sview>%s</%sview>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(view_), input_name='view')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'view':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'view')
            value_ = self.gds_validate_string(value_, node, 'view')
            self.view.append(value_)
            self.view_nsprefix_ = child_.prefix
# end class GLMGetViewListDone


class GLMGetData(GeneratedsSuper):
    """Message from ioGAS asking to open a data table from the client.Request
    the data for the given view (this will be one of the views names that
    the client has already provided in a GLMGetvViewListDone message."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, viewName=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.viewName = _cast(None, viewName)
        self.viewName_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMGetData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMGetData.subclass:
            return GLMGetData.subclass(*args_, **kwargs_)
        else:
            return GLMGetData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_viewName(self):
        return self.viewName
    def set_viewName(self, viewName):
        self.viewName = viewName
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetData', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMGetData')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMGetData')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMGetData', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMGetData'):
        if self.viewName is not None and 'viewName' not in already_processed:
            already_processed.add('viewName')
            outfile.write(' viewName=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.viewName), input_name='viewName')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetData', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('viewName', node)
        if value is not None and 'viewName' not in already_processed:
            already_processed.add('viewName')
            self.viewName = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class GLMGetData


class GLMGetDataDone(GeneratedsSuper):
    """Message to ioGAS containing all the data. The format is the same as
    GLMSendData.
    True if gas has no data loaded."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, stateNull=None, specialColumns=None, columns=None, DRs=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.stateNull = _cast(bool, stateNull)
        self.stateNull_nsprefix_ = None
        self.specialColumns = specialColumns
        self.specialColumns_nsprefix_ = None
        self.columns = columns
        self.columns_nsprefix_ = None
        self.DRs = DRs
        self.DRs_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GLMGetDataDone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GLMGetDataDone.subclass:
            return GLMGetDataDone.subclass(*args_, **kwargs_)
        else:
            return GLMGetDataDone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_specialColumns(self):
        return self.specialColumns
    def set_specialColumns(self, specialColumns):
        self.specialColumns = specialColumns
    def get_columns(self):
        return self.columns
    def set_columns(self, columns):
        self.columns = columns
    def get_DRs(self):
        return self.DRs
    def set_DRs(self, DRs):
        self.DRs = DRs
    def get_stateNull(self):
        return self.stateNull
    def set_stateNull(self, stateNull):
        self.stateNull = stateNull
    def hasContent_(self):
        if (
            self.specialColumns is not None or
            self.columns is not None or
            self.DRs is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetDataDone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GLMGetDataDone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GLMGetDataDone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GLMGetDataDone', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GLMGetDataDone'):
        if self.stateNull is not None and 'stateNull' not in already_processed:
            already_processed.add('stateNull')
            outfile.write(' stateNull="%s"' % self.gds_format_boolean(self.stateNull, input_name='stateNull'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GLMGetDataDone', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.specialColumns is not None:
            namespaceprefix_ = self.specialColumns_nsprefix_ + ':' if (UseCapturedNS_ and self.specialColumns_nsprefix_) else ''
            self.specialColumns.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specialColumns', pretty_print=pretty_print)
        if self.columns is not None:
            namespaceprefix_ = self.columns_nsprefix_ + ':' if (UseCapturedNS_ and self.columns_nsprefix_) else ''
            self.columns.export(outfile, level, namespaceprefix_, namespacedef_='', name_='columns', pretty_print=pretty_print)
        if self.DRs is not None:
            namespaceprefix_ = self.DRs_nsprefix_ + ':' if (UseCapturedNS_ and self.DRs_nsprefix_) else ''
            self.DRs.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DRs', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('stateNull', node)
        if value is not None and 'stateNull' not in already_processed:
            already_processed.add('stateNull')
            if value in ('true', '1'):
                self.stateNull = True
            elif value in ('false', '0'):
                self.stateNull = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'specialColumns':
            obj_ = xSpecialColumns.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specialColumns = obj_
            obj_.original_tagname_ = 'specialColumns'
        elif nodeName_ == 'columns':
            obj_ = xColumns.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.columns = obj_
            obj_.original_tagname_ = 'columns'
        elif nodeName_ == 'DRs':
            obj_ = xDRs.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DRs = obj_
            obj_.original_tagname_ = 'DRs'
# end class GLMGetDataDone


class xColourAttributes(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, title=None, colourAttribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if colourAttribute is None:
            self.colourAttribute = []
        else:
            self.colourAttribute = colourAttribute
        self.colourAttribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xColourAttributes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xColourAttributes.subclass:
            return xColourAttributes.subclass(*args_, **kwargs_)
        else:
            return xColourAttributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_colourAttribute(self):
        return self.colourAttribute
    def set_colourAttribute(self, colourAttribute):
        self.colourAttribute = colourAttribute
    def add_colourAttribute(self, value):
        self.colourAttribute.append(value)
    def insert_colourAttribute_at(self, index, value):
        self.colourAttribute.insert(index, value)
    def replace_colourAttribute_at(self, index, value):
        self.colourAttribute[index] = value
    def hasContent_(self):
        if (
            self.title is not None or
            self.colourAttribute
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColourAttributes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xColourAttributes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xColourAttributes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xColourAttributes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xColourAttributes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColourAttributes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for colourAttribute_ in self.colourAttribute:
            namespaceprefix_ = self.colourAttribute_nsprefix_ + ':' if (UseCapturedNS_ and self.colourAttribute_nsprefix_) else ''
            colourAttribute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='colourAttribute', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'colourAttribute':
            obj_ = xColourAttribute.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.colourAttribute.append(obj_)
            obj_.original_tagname_ = 'colourAttribute'
# end class xColourAttributes


class xShapeAttributes(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, title=None, shapeAttribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if shapeAttribute is None:
            self.shapeAttribute = []
        else:
            self.shapeAttribute = shapeAttribute
        self.shapeAttribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xShapeAttributes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xShapeAttributes.subclass:
            return xShapeAttributes.subclass(*args_, **kwargs_)
        else:
            return xShapeAttributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_shapeAttribute(self):
        return self.shapeAttribute
    def set_shapeAttribute(self, shapeAttribute):
        self.shapeAttribute = shapeAttribute
    def add_shapeAttribute(self, value):
        self.shapeAttribute.append(value)
    def insert_shapeAttribute_at(self, index, value):
        self.shapeAttribute.insert(index, value)
    def replace_shapeAttribute_at(self, index, value):
        self.shapeAttribute[index] = value
    def hasContent_(self):
        if (
            self.title is not None or
            self.shapeAttribute
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xShapeAttributes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xShapeAttributes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xShapeAttributes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xShapeAttributes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xShapeAttributes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xShapeAttributes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for shapeAttribute_ in self.shapeAttribute:
            namespaceprefix_ = self.shapeAttribute_nsprefix_ + ':' if (UseCapturedNS_ and self.shapeAttribute_nsprefix_) else ''
            shapeAttribute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shapeAttribute', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'shapeAttribute':
            obj_ = xShapeAttribute.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shapeAttribute.append(obj_)
            obj_.original_tagname_ = 'shapeAttribute'
# end class xShapeAttributes


class xSizeAttributes(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, title=None, sizeAttribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if sizeAttribute is None:
            self.sizeAttribute = []
        else:
            self.sizeAttribute = sizeAttribute
        self.sizeAttribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xSizeAttributes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xSizeAttributes.subclass:
            return xSizeAttributes.subclass(*args_, **kwargs_)
        else:
            return xSizeAttributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_sizeAttribute(self):
        return self.sizeAttribute
    def set_sizeAttribute(self, sizeAttribute):
        self.sizeAttribute = sizeAttribute
    def add_sizeAttribute(self, value):
        self.sizeAttribute.append(value)
    def insert_sizeAttribute_at(self, index, value):
        self.sizeAttribute.insert(index, value)
    def replace_sizeAttribute_at(self, index, value):
        self.sizeAttribute[index] = value
    def hasContent_(self):
        if (
            self.title is not None or
            self.sizeAttribute
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xSizeAttributes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xSizeAttributes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xSizeAttributes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xSizeAttributes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xSizeAttributes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xSizeAttributes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for sizeAttribute_ in self.sizeAttribute:
            namespaceprefix_ = self.sizeAttribute_nsprefix_ + ':' if (UseCapturedNS_ and self.sizeAttribute_nsprefix_) else ''
            sizeAttribute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sizeAttribute', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'sizeAttribute':
            obj_ = xSizeAttribute.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sizeAttribute.append(obj_)
            obj_.original_tagname_ = 'sizeAttribute'
# end class xSizeAttributes


class xFilterAttributes(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, title=None, filterAttribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if filterAttribute is None:
            self.filterAttribute = []
        else:
            self.filterAttribute = filterAttribute
        self.filterAttribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xFilterAttributes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xFilterAttributes.subclass:
            return xFilterAttributes.subclass(*args_, **kwargs_)
        else:
            return xFilterAttributes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_filterAttribute(self):
        return self.filterAttribute
    def set_filterAttribute(self, filterAttribute):
        self.filterAttribute = filterAttribute
    def add_filterAttribute(self, value):
        self.filterAttribute.append(value)
    def insert_filterAttribute_at(self, index, value):
        self.filterAttribute.insert(index, value)
    def replace_filterAttribute_at(self, index, value):
        self.filterAttribute[index] = value
    def hasContent_(self):
        if (
            self.title is not None or
            self.filterAttribute
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xFilterAttributes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xFilterAttributes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xFilterAttributes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xFilterAttributes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xFilterAttributes'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xFilterAttributes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for filterAttribute_ in self.filterAttribute:
            namespaceprefix_ = self.filterAttribute_nsprefix_ + ':' if (UseCapturedNS_ and self.filterAttribute_nsprefix_) else ''
            filterAttribute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='filterAttribute', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'filterAttribute':
            obj_ = xFilterAttribute.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.filterAttribute.append(obj_)
            obj_.original_tagname_ = 'filterAttribute'
# end class xFilterAttributes


class xColumns(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, column=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if column is None:
            self.column = []
        else:
            self.column = column
        self.column_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xColumns)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xColumns.subclass:
            return xColumns.subclass(*args_, **kwargs_)
        else:
            return xColumns(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_column(self):
        return self.column
    def set_column(self, column):
        self.column = column
    def add_column(self, value):
        self.column.append(value)
    def insert_column_at(self, index, value):
        self.column.insert(index, value)
    def replace_column_at(self, index, value):
        self.column[index] = value
    def hasContent_(self):
        if (
            self.column
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColumns', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xColumns')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xColumns')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xColumns', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xColumns'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColumns', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for column_ in self.column:
            namespaceprefix_ = self.column_nsprefix_ + ':' if (UseCapturedNS_ and self.column_nsprefix_) else ''
            column_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='column', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'column':
            obj_ = xColumn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.column.append(obj_)
            obj_.original_tagname_ = 'column'
# end class xColumns


class xColumn(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, origonalName=None, aliasName=None, type_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.origonalName = origonalName
        self.origonalName_nsprefix_ = None
        self.aliasName = aliasName
        self.aliasName_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xColumn)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xColumn.subclass:
            return xColumn.subclass(*args_, **kwargs_)
        else:
            return xColumn(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_origonalName(self):
        return self.origonalName
    def set_origonalName(self, origonalName):
        self.origonalName = origonalName
    def get_aliasName(self):
        return self.aliasName
    def set_aliasName(self, aliasName):
        self.aliasName = aliasName
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def hasContent_(self):
        if (
            self.origonalName is not None or
            self.aliasName is not None or
            self.type_ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColumn', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xColumn')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xColumn')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xColumn', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xColumn'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColumn', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.origonalName is not None:
            namespaceprefix_ = self.origonalName_nsprefix_ + ':' if (UseCapturedNS_ and self.origonalName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorigonalName>%s</%sorigonalName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.origonalName), input_name='origonalName')), namespaceprefix_ , eol_))
        if self.aliasName is not None:
            namespaceprefix_ = self.aliasName_nsprefix_ + ':' if (UseCapturedNS_ and self.aliasName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saliasName>%s</%saliasName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.aliasName), input_name='aliasName')), namespaceprefix_ , eol_))
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'origonalName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'origonalName')
            value_ = self.gds_validate_string(value_, node, 'origonalName')
            self.origonalName = value_
            self.origonalName_nsprefix_ = child_.prefix
        elif nodeName_ == 'aliasName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'aliasName')
            value_ = self.gds_validate_string(value_, node, 'aliasName')
            self.aliasName = value_
            self.aliasName_nsprefix_ = child_.prefix
        elif nodeName_ == 'type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'type')
            value_ = self.gds_validate_string(value_, node, 'type')
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
# end class xColumn


class xSpecialColumns(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, map_east=None, map_north=None, map_elevation=None, map_proj=None, map_epsg=None, wgs84longitude=None, wgs84latitude=None, dh_group=None, dh_depth_from=None, dh_depth_to=None, sn_dip=None, sn_azimuth=None, sn_structure_type=None, id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.map_east = map_east
        self.map_east_nsprefix_ = None
        self.map_north = map_north
        self.map_north_nsprefix_ = None
        self.map_elevation = map_elevation
        self.map_elevation_nsprefix_ = None
        self.map_proj = map_proj
        self.map_proj_nsprefix_ = None
        self.map_epsg = map_epsg
        self.map_epsg_nsprefix_ = None
        self.wgs84longitude = wgs84longitude
        self.wgs84longitude_nsprefix_ = None
        self.wgs84latitude = wgs84latitude
        self.wgs84latitude_nsprefix_ = None
        self.dh_group = dh_group
        self.dh_group_nsprefix_ = None
        self.dh_depth_from = dh_depth_from
        self.dh_depth_from_nsprefix_ = None
        self.dh_depth_to = dh_depth_to
        self.dh_depth_to_nsprefix_ = None
        self.sn_dip = sn_dip
        self.sn_dip_nsprefix_ = None
        self.sn_azimuth = sn_azimuth
        self.sn_azimuth_nsprefix_ = None
        self.sn_structure_type = sn_structure_type
        self.sn_structure_type_nsprefix_ = None
        self.id = id
        self.id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xSpecialColumns)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xSpecialColumns.subclass:
            return xSpecialColumns.subclass(*args_, **kwargs_)
        else:
            return xSpecialColumns(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_map_east(self):
        return self.map_east
    def set_map_east(self, map_east):
        self.map_east = map_east
    def get_map_north(self):
        return self.map_north
    def set_map_north(self, map_north):
        self.map_north = map_north
    def get_map_elevation(self):
        return self.map_elevation
    def set_map_elevation(self, map_elevation):
        self.map_elevation = map_elevation
    def get_map_proj(self):
        return self.map_proj
    def set_map_proj(self, map_proj):
        self.map_proj = map_proj
    def get_map_epsg(self):
        return self.map_epsg
    def set_map_epsg(self, map_epsg):
        self.map_epsg = map_epsg
    def get_wgs84longitude(self):
        return self.wgs84longitude
    def set_wgs84longitude(self, wgs84longitude):
        self.wgs84longitude = wgs84longitude
    def get_wgs84latitude(self):
        return self.wgs84latitude
    def set_wgs84latitude(self, wgs84latitude):
        self.wgs84latitude = wgs84latitude
    def get_dh_group(self):
        return self.dh_group
    def set_dh_group(self, dh_group):
        self.dh_group = dh_group
    def get_dh_depth_from(self):
        return self.dh_depth_from
    def set_dh_depth_from(self, dh_depth_from):
        self.dh_depth_from = dh_depth_from
    def get_dh_depth_to(self):
        return self.dh_depth_to
    def set_dh_depth_to(self, dh_depth_to):
        self.dh_depth_to = dh_depth_to
    def get_sn_dip(self):
        return self.sn_dip
    def set_sn_dip(self, sn_dip):
        self.sn_dip = sn_dip
    def get_sn_azimuth(self):
        return self.sn_azimuth
    def set_sn_azimuth(self, sn_azimuth):
        self.sn_azimuth = sn_azimuth
    def get_sn_structure_type(self):
        return self.sn_structure_type
    def set_sn_structure_type(self, sn_structure_type):
        self.sn_structure_type = sn_structure_type
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def hasContent_(self):
        if (
            self.map_east is not None or
            self.map_north is not None or
            self.map_elevation is not None or
            self.map_proj is not None or
            self.map_epsg is not None or
            self.wgs84longitude is not None or
            self.wgs84latitude is not None or
            self.dh_group is not None or
            self.dh_depth_from is not None or
            self.dh_depth_to is not None or
            self.sn_dip is not None or
            self.sn_azimuth is not None or
            self.sn_structure_type is not None or
            self.id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xSpecialColumns', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xSpecialColumns')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xSpecialColumns')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xSpecialColumns', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xSpecialColumns'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xSpecialColumns', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.map_east is not None:
            namespaceprefix_ = self.map_east_nsprefix_ + ':' if (UseCapturedNS_ and self.map_east_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smap_east>%s</%smap_east>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.map_east), input_name='map_east')), namespaceprefix_ , eol_))
        if self.map_north is not None:
            namespaceprefix_ = self.map_north_nsprefix_ + ':' if (UseCapturedNS_ and self.map_north_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smap_north>%s</%smap_north>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.map_north), input_name='map_north')), namespaceprefix_ , eol_))
        if self.map_elevation is not None:
            namespaceprefix_ = self.map_elevation_nsprefix_ + ':' if (UseCapturedNS_ and self.map_elevation_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smap_elevation>%s</%smap_elevation>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.map_elevation), input_name='map_elevation')), namespaceprefix_ , eol_))
        if self.map_proj is not None:
            namespaceprefix_ = self.map_proj_nsprefix_ + ':' if (UseCapturedNS_ and self.map_proj_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smap_proj>%s</%smap_proj>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.map_proj), input_name='map_proj')), namespaceprefix_ , eol_))
        if self.map_epsg is not None:
            namespaceprefix_ = self.map_epsg_nsprefix_ + ':' if (UseCapturedNS_ and self.map_epsg_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smap_epsg>%s</%smap_epsg>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.map_epsg), input_name='map_epsg')), namespaceprefix_ , eol_))
        if self.wgs84longitude is not None:
            namespaceprefix_ = self.wgs84longitude_nsprefix_ + ':' if (UseCapturedNS_ and self.wgs84longitude_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swgs84longitude>%s</%swgs84longitude>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.wgs84longitude), input_name='wgs84longitude')), namespaceprefix_ , eol_))
        if self.wgs84latitude is not None:
            namespaceprefix_ = self.wgs84latitude_nsprefix_ + ':' if (UseCapturedNS_ and self.wgs84latitude_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swgs84latitude>%s</%swgs84latitude>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.wgs84latitude), input_name='wgs84latitude')), namespaceprefix_ , eol_))
        if self.dh_group is not None:
            namespaceprefix_ = self.dh_group_nsprefix_ + ':' if (UseCapturedNS_ and self.dh_group_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdh_group>%s</%sdh_group>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dh_group), input_name='dh_group')), namespaceprefix_ , eol_))
        if self.dh_depth_from is not None:
            namespaceprefix_ = self.dh_depth_from_nsprefix_ + ':' if (UseCapturedNS_ and self.dh_depth_from_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdh_depth_from>%s</%sdh_depth_from>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dh_depth_from), input_name='dh_depth_from')), namespaceprefix_ , eol_))
        if self.dh_depth_to is not None:
            namespaceprefix_ = self.dh_depth_to_nsprefix_ + ':' if (UseCapturedNS_ and self.dh_depth_to_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdh_depth_to>%s</%sdh_depth_to>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.dh_depth_to), input_name='dh_depth_to')), namespaceprefix_ , eol_))
        if self.sn_dip is not None:
            namespaceprefix_ = self.sn_dip_nsprefix_ + ':' if (UseCapturedNS_ and self.sn_dip_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssn_dip>%s</%ssn_dip>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sn_dip), input_name='sn_dip')), namespaceprefix_ , eol_))
        if self.sn_azimuth is not None:
            namespaceprefix_ = self.sn_azimuth_nsprefix_ + ':' if (UseCapturedNS_ and self.sn_azimuth_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssn_azimuth>%s</%ssn_azimuth>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sn_azimuth), input_name='sn_azimuth')), namespaceprefix_ , eol_))
        if self.sn_structure_type is not None:
            namespaceprefix_ = self.sn_structure_type_nsprefix_ + ':' if (UseCapturedNS_ and self.sn_structure_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssn_structure_type>%s</%ssn_structure_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sn_structure_type), input_name='sn_structure_type')), namespaceprefix_ , eol_))
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.id), input_name='id')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'map_east':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'map_east')
            value_ = self.gds_validate_string(value_, node, 'map_east')
            self.map_east = value_
            self.map_east_nsprefix_ = child_.prefix
        elif nodeName_ == 'map_north':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'map_north')
            value_ = self.gds_validate_string(value_, node, 'map_north')
            self.map_north = value_
            self.map_north_nsprefix_ = child_.prefix
        elif nodeName_ == 'map_elevation':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'map_elevation')
            value_ = self.gds_validate_string(value_, node, 'map_elevation')
            self.map_elevation = value_
            self.map_elevation_nsprefix_ = child_.prefix
        elif nodeName_ == 'map_proj':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'map_proj')
            value_ = self.gds_validate_string(value_, node, 'map_proj')
            self.map_proj = value_
            self.map_proj_nsprefix_ = child_.prefix
        elif nodeName_ == 'map_epsg':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'map_epsg')
            value_ = self.gds_validate_string(value_, node, 'map_epsg')
            self.map_epsg = value_
            self.map_epsg_nsprefix_ = child_.prefix
        elif nodeName_ == 'wgs84longitude':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'wgs84longitude')
            value_ = self.gds_validate_string(value_, node, 'wgs84longitude')
            self.wgs84longitude = value_
            self.wgs84longitude_nsprefix_ = child_.prefix
        elif nodeName_ == 'wgs84latitude':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'wgs84latitude')
            value_ = self.gds_validate_string(value_, node, 'wgs84latitude')
            self.wgs84latitude = value_
            self.wgs84latitude_nsprefix_ = child_.prefix
        elif nodeName_ == 'dh_group':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dh_group')
            value_ = self.gds_validate_string(value_, node, 'dh_group')
            self.dh_group = value_
            self.dh_group_nsprefix_ = child_.prefix
        elif nodeName_ == 'dh_depth_from':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dh_depth_from')
            value_ = self.gds_validate_string(value_, node, 'dh_depth_from')
            self.dh_depth_from = value_
            self.dh_depth_from_nsprefix_ = child_.prefix
        elif nodeName_ == 'dh_depth_to':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'dh_depth_to')
            value_ = self.gds_validate_string(value_, node, 'dh_depth_to')
            self.dh_depth_to = value_
            self.dh_depth_to_nsprefix_ = child_.prefix
        elif nodeName_ == 'sn_dip':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'sn_dip')
            value_ = self.gds_validate_string(value_, node, 'sn_dip')
            self.sn_dip = value_
            self.sn_dip_nsprefix_ = child_.prefix
        elif nodeName_ == 'sn_azimuth':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'sn_azimuth')
            value_ = self.gds_validate_string(value_, node, 'sn_azimuth')
            self.sn_azimuth = value_
            self.sn_azimuth_nsprefix_ = child_.prefix
        elif nodeName_ == 'sn_structure_type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'sn_structure_type')
            value_ = self.gds_validate_string(value_, node, 'sn_structure_type')
            self.sn_structure_type = value_
            self.sn_structure_type_nsprefix_ = child_.prefix
        elif nodeName_ == 'id':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'id')
            value_ = self.gds_validate_string(value_, node, 'id')
            self.id = value_
            self.id_nsprefix_ = child_.prefix
# end class xSpecialColumns


class xRows(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Row=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Row is None:
            self.Row = []
        else:
            self.Row = Row
        self.Row_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xRows)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xRows.subclass:
            return xRows.subclass(*args_, **kwargs_)
        else:
            return xRows(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Row(self):
        return self.Row
    def set_Row(self, Row):
        self.Row = Row
    def add_Row(self, value):
        self.Row.append(value)
    def insert_Row_at(self, index, value):
        self.Row.insert(index, value)
    def replace_Row_at(self, index, value):
        self.Row[index] = value
    def hasContent_(self):
        if (
            self.Row
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xRows', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xRows')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xRows')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xRows', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xRows'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xRows', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Row_ in self.Row:
            namespaceprefix_ = self.Row_nsprefix_ + ':' if (UseCapturedNS_ and self.Row_nsprefix_) else ''
            Row_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Row', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Row':
            obj_ = xRow.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Row.append(obj_)
            obj_.original_tagname_ = 'Row'
# end class xRows


class xRow(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, colour=None, shape=None, size=None, filter=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.colour = _cast(int, colour)
        self.colour_nsprefix_ = None
        self.shape = _cast(int, shape)
        self.shape_nsprefix_ = None
        self.size = _cast(int, size)
        self.size_nsprefix_ = None
        self.filter = _cast(int, filter)
        self.filter_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xRow)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xRow.subclass:
            return xRow.subclass(*args_, **kwargs_)
        else:
            return xRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_colour(self):
        return self.colour
    def set_colour(self, colour):
        self.colour = colour
    def get_shape(self):
        return self.shape
    def set_shape(self, shape):
        self.shape = shape
    def get_size(self):
        return self.size
    def set_size(self, size):
        self.size = size
    def get_filter(self):
        return self.filter
    def set_filter(self, filter):
        self.filter = filter
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xRow', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xRow')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xRow')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xRow', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xRow'):
        if self.colour is not None and 'colour' not in already_processed:
            already_processed.add('colour')
            outfile.write(' colour="%s"' % self.gds_format_integer(self.colour, input_name='colour'))
        if self.shape is not None and 'shape' not in already_processed:
            already_processed.add('shape')
            outfile.write(' shape="%s"' % self.gds_format_integer(self.shape, input_name='shape'))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size="%s"' % self.gds_format_integer(self.size, input_name='size'))
        if self.filter is not None and 'filter' not in already_processed:
            already_processed.add('filter')
            outfile.write(' filter="%s"' % self.gds_format_integer(self.filter, input_name='filter'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xRow', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('colour', node)
        if value is not None and 'colour' not in already_processed:
            already_processed.add('colour')
            self.colour = self.gds_parse_integer(value, node, 'colour')
        value = find_attr_value_('shape', node)
        if value is not None and 'shape' not in already_processed:
            already_processed.add('shape')
            self.shape = self.gds_parse_integer(value, node, 'shape')
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            self.size = self.gds_parse_integer(value, node, 'size')
        value = find_attr_value_('filter', node)
        if value is not None and 'filter' not in already_processed:
            already_processed.add('filter')
            self.filter = self.gds_parse_integer(value, node, 'filter')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class xRow


class xDRs(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, DR=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if DR is None:
            self.DR = []
        else:
            self.DR = DR
        self.DR_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xDRs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xDRs.subclass:
            return xDRs.subclass(*args_, **kwargs_)
        else:
            return xDRs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_DR(self):
        return self.DR
    def set_DR(self, DR):
        self.DR = DR
    def add_DR(self, value):
        self.DR.append(value)
    def insert_DR_at(self, index, value):
        self.DR.insert(index, value)
    def replace_DR_at(self, index, value):
        self.DR[index] = value
    def hasContent_(self):
        if (
            self.DR
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xDRs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xDRs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xDRs')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xDRs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xDRs'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xDRs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DR_ in self.DR:
            namespaceprefix_ = self.DR_nsprefix_ + ':' if (UseCapturedNS_ and self.DR_nsprefix_) else ''
            DR_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DR', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DR':
            obj_ = xDR.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DR.append(obj_)
            obj_.original_tagname_ = 'DR'
# end class xDRs


class xDR(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, dummy=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dummy = _cast(int, dummy)
        self.dummy_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xDR)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xDR.subclass:
            return xDR.subclass(*args_, **kwargs_)
        else:
            return xDR(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_dummy(self):
        return self.dummy
    def set_dummy(self, dummy):
        self.dummy = dummy
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xDR', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xDR')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xDR')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xDR', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xDR'):
        if self.dummy is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            outfile.write(' dummy="%s"' % self.gds_format_integer(self.dummy, input_name='dummy'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xDR', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dummy', node)
        if value is not None and 'dummy' not in already_processed:
            already_processed.add('dummy')
            self.dummy = self.gds_parse_integer(value, node, 'dummy')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class xDR


class xColourAttribute(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, colour=None, visible=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.colour = colour
        self.colour_nsprefix_ = None
        self.visible = visible
        self.visible_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xColourAttribute)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xColourAttribute.subclass:
            return xColourAttribute.subclass(*args_, **kwargs_)
        else:
            return xColourAttribute(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_colour(self):
        return self.colour
    def set_colour(self, colour):
        self.colour = colour
    def get_visible(self):
        return self.visible
    def set_visible(self, visible):
        self.visible = visible
    def hasContent_(self):
        if (
            self.name is not None or
            self.colour is not None or
            self.visible is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColourAttribute', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xColourAttribute')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xColourAttribute')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xColourAttribute', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xColourAttribute'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xColourAttribute', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.colour is not None:
            namespaceprefix_ = self.colour_nsprefix_ + ':' if (UseCapturedNS_ and self.colour_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scolour>%s</%scolour>%s' % (namespaceprefix_ , self.gds_format_integer(self.colour, input_name='colour'), namespaceprefix_ , eol_))
        if self.visible is not None:
            namespaceprefix_ = self.visible_nsprefix_ + ':' if (UseCapturedNS_ and self.visible_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svisible>%s</%svisible>%s' % (namespaceprefix_ , self.gds_format_boolean(self.visible, input_name='visible'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'colour' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'colour')
            ival_ = self.gds_validate_integer(ival_, node, 'colour')
            self.colour = ival_
            self.colour_nsprefix_ = child_.prefix
        elif nodeName_ == 'visible':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'visible')
            ival_ = self.gds_validate_boolean(ival_, node, 'visible')
            self.visible = ival_
            self.visible_nsprefix_ = child_.prefix
# end class xColourAttribute


class xShapeAttribute(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, shape=None, visible=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.shape = shape
        self.shape_nsprefix_ = None
        self.visible = visible
        self.visible_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xShapeAttribute)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xShapeAttribute.subclass:
            return xShapeAttribute.subclass(*args_, **kwargs_)
        else:
            return xShapeAttribute(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_shape(self):
        return self.shape
    def set_shape(self, shape):
        self.shape = shape
    def get_visible(self):
        return self.visible
    def set_visible(self, visible):
        self.visible = visible
    def hasContent_(self):
        if (
            self.name is not None or
            self.shape is not None or
            self.visible is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xShapeAttribute', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xShapeAttribute')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xShapeAttribute')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xShapeAttribute', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xShapeAttribute'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xShapeAttribute', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.shape is not None:
            namespaceprefix_ = self.shape_nsprefix_ + ':' if (UseCapturedNS_ and self.shape_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshape>%s</%sshape>%s' % (namespaceprefix_ , self.gds_format_integer(self.shape, input_name='shape'), namespaceprefix_ , eol_))
        if self.visible is not None:
            namespaceprefix_ = self.visible_nsprefix_ + ':' if (UseCapturedNS_ and self.visible_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svisible>%s</%svisible>%s' % (namespaceprefix_ , self.gds_format_boolean(self.visible, input_name='visible'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'shape' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'shape')
            ival_ = self.gds_validate_integer(ival_, node, 'shape')
            self.shape = ival_
            self.shape_nsprefix_ = child_.prefix
        elif nodeName_ == 'visible':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'visible')
            ival_ = self.gds_validate_boolean(ival_, node, 'visible')
            self.visible = ival_
            self.visible_nsprefix_ = child_.prefix
# end class xShapeAttribute


class xSizeAttribute(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, size=None, visible=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.size = size
        self.size_nsprefix_ = None
        self.visible = visible
        self.visible_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xSizeAttribute)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xSizeAttribute.subclass:
            return xSizeAttribute.subclass(*args_, **kwargs_)
        else:
            return xSizeAttribute(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_size(self):
        return self.size
    def set_size(self, size):
        self.size = size
    def get_visible(self):
        return self.visible
    def set_visible(self, visible):
        self.visible = visible
    def hasContent_(self):
        if (
            self.name is not None or
            self.size is not None or
            self.visible is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xSizeAttribute', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xSizeAttribute')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xSizeAttribute')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xSizeAttribute', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xSizeAttribute'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xSizeAttribute', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.size is not None:
            namespaceprefix_ = self.size_nsprefix_ + ':' if (UseCapturedNS_ and self.size_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespaceprefix_ , self.gds_format_integer(self.size, input_name='size'), namespaceprefix_ , eol_))
        if self.visible is not None:
            namespaceprefix_ = self.visible_nsprefix_ + ':' if (UseCapturedNS_ and self.visible_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svisible>%s</%svisible>%s' % (namespaceprefix_ , self.gds_format_boolean(self.visible, input_name='visible'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'size' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'size')
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
            self.size_nsprefix_ = child_.prefix
        elif nodeName_ == 'visible':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'visible')
            ival_ = self.gds_validate_boolean(ival_, node, 'visible')
            self.visible = ival_
            self.visible_nsprefix_ = child_.prefix
# end class xSizeAttribute


class xFilterAttribute(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, visible=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.visible = visible
        self.visible_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, xFilterAttribute)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if xFilterAttribute.subclass:
            return xFilterAttribute.subclass(*args_, **kwargs_)
        else:
            return xFilterAttribute(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_visible(self):
        return self.visible
    def set_visible(self, visible):
        self.visible = visible
    def hasContent_(self):
        if (
            self.name is not None or
            self.visible is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xFilterAttribute', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('xFilterAttribute')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='xFilterAttribute')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='xFilterAttribute', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='xFilterAttribute'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='xFilterAttribute', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.visible is not None:
            namespaceprefix_ = self.visible_nsprefix_ + ':' if (UseCapturedNS_ and self.visible_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svisible>%s</%svisible>%s' % (namespaceprefix_ , self.gds_format_boolean(self.visible, input_name='visible'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'visible':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'visible')
            ival_ = self.gds_validate_boolean(ival_, node, 'visible')
            self.visible = ival_
            self.visible_nsprefix_ = child_.prefix
# end class xFilterAttribute


class Test1(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, testString=None, testBool=None, subEl=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.testString = _cast(None, testString)
        self.testString_nsprefix_ = None
        self.testBool = _cast(bool, testBool)
        self.testBool_nsprefix_ = None
        self.subEl = subEl
        self.subEl_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Test1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Test1.subclass:
            return Test1.subclass(*args_, **kwargs_)
        else:
            return Test1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_subEl(self):
        return self.subEl
    def set_subEl(self, subEl):
        self.subEl = subEl
    def get_testString(self):
        return self.testString
    def set_testString(self, testString):
        self.testString = testString
    def get_testBool(self):
        return self.testBool
    def set_testBool(self, testBool):
        self.testBool = testBool
    def hasContent_(self):
        if (
            self.subEl is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Test1', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Test1')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Test1')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Test1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Test1'):
        if self.testString is not None and 'testString' not in already_processed:
            already_processed.add('testString')
            outfile.write(' testString=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.testString), input_name='testString')), ))
        if self.testBool is not None and 'testBool' not in already_processed:
            already_processed.add('testBool')
            outfile.write(' testBool="%s"' % self.gds_format_boolean(self.testBool, input_name='testBool'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Test1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.subEl is not None:
            namespaceprefix_ = self.subEl_nsprefix_ + ':' if (UseCapturedNS_ and self.subEl_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssubEl>%s</%ssubEl>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.subEl), input_name='subEl')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('testString', node)
        if value is not None and 'testString' not in already_processed:
            already_processed.add('testString')
            self.testString = value
        value = find_attr_value_('testBool', node)
        if value is not None and 'testBool' not in already_processed:
            already_processed.add('testBool')
            if value in ('true', '1'):
                self.testBool = True
            elif value in ('false', '0'):
                self.testBool = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'subEl':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'subEl')
            value_ = self.gds_validate_string(value_, node, 'subEl')
            self.subEl = value_
            self.subEl_nsprefix_ = child_.prefix
# end class Test1


class Test2(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, testString=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.testString = _cast(None, testString)
        self.testString_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Test2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Test2.subclass:
            return Test2.subclass(*args_, **kwargs_)
        else:
            return Test2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_testString(self):
        return self.testString
    def set_testString(self, testString):
        self.testString = testString
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Test2', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Test2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Test2')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Test2', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Test2'):
        if self.testString is not None and 'testString' not in already_processed:
            already_processed.add('testString')
            outfile.write(' testString=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.testString), input_name='testString')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Test2', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('testString', node)
        if value is not None and 'testString' not in already_processed:
            already_processed.add('testString')
            self.testString = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class Test2


GDSClassesMapping = {
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def get_required_ns_prefix_defs(rootNode):
    '''Get all name space prefix definitions required in this XML doc.
    Return a dictionary of definitions and a char string of definitions.
    '''
    nsmap = {
        prefix: uri
        for node in rootNode.iter()
        for (prefix, uri) in node.nsmap.items()
        if prefix is not None
    }
    namespacedefs = ' '.join([
        'xmlns:{}="{}"'.format(prefix, uri)
        for prefix, uri in nsmap.items()
    ])
    return nsmap, namespacedefs


def parse(inFileName, silence=False, print_warnings=True):
    global CapturedNsmap_
    gds_collector = GdsCollector_()
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Protocol'
        rootClass = Protocol
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    CapturedNsmap_, namespacedefs = get_required_ns_prefix_defs(rootNode)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_=namespacedefs,
            pretty_print=True)
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseEtree(inFileName, silence=False, print_warnings=True):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Protocol'
        rootClass = Protocol
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(str(content))
        sys.stdout.write('\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False, print_warnings=True):
    '''Parse a string, create the object tree, and export it.

    Arguments:
    - inString -- A string.  This XML fragment should not start
      with an XML declaration containing an encoding.
    - silence -- A boolean.  If False, export the object.
    Returns -- The root object in the tree.
    '''
    parser = None
    rootNode= parsexmlstring_(inString, parser)
    gds_collector = GdsCollector_()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Protocol'
        rootClass = Protocol
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    if not SaveElementTreeNode:
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseLiteral(inFileName, silence=False, print_warnings=True):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Protocol'
        rootClass = Protocol
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('#from gaslink import *\n\n')
        sys.stdout.write('import gaslink as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

RenameMappings_ = {
}

__all__ = [
    "GLMAddColumn",
    "GLMAddColumnDone",
    "GLMApplyAttributes",
    "GLMApplyAttributesDone",
    "GLMConnect",
    "GLMConnectDone",
    "GLMGetData",
    "GLMGetDataDone",
    "GLMGetViewList",
    "GLMGetViewListDone",
    "GLMPing",
    "GLMPingDone",
    "GLMSendAttributes",
    "GLMSendAttributesDone",
    "GLMSendData",
    "GLMSendDataDone",
    "Protocol",
    "Test1",
    "Test2",
    "xColourAttribute",
    "xColourAttributes",
    "xColumn",
    "xColumns",
    "xDR",
    "xDRs",
    "xFilterAttribute",
    "xFilterAttributes",
    "xRow",
    "xRows",
    "xShapeAttribute",
    "xShapeAttributes",
    "xSizeAttribute",
    "xSizeAttributes",
    "xSpecialColumns"
]
