
import sys
from collections import namedtuple
from operator import itemgetter


try:
    import ioGAS.gaslink as gaslink
    import ioGAS.gas as gas  # used by gaslink
    import ioGAS.gassupport as gassupport
except:
    import gaslink
    import gas
    import gassupport 
    
ERR_EN = "East and North fields must be set in ioGAS. File will not be loaded"



# a structure to hold components of gas data
class GasData_Base():

    Column = namedtuple('Column', 'name type index')
    Colour = namedtuple('Colour', 'name colour visible')
    Shape = namedtuple('Shape', 'name shapeCode visible')
    Size = namedtuple('Size', 'name size visible')
    Filter = namedtuple('Filter', 'name visible')

    def __init__(self, pSignalling):
        super().__init__()  #?

        self.signalling = pSignalling  
                
        # can't log in ctor as signale not wired up
        self.initialise()  


    def initialise(self):   
        #possible load problem
        self.warning = False
        self.validationMessage = ""

        self.name = None # og filename
        
        #lists of attributes as named tuples
        self.filters = []
        self.colours = []
        self.shapes = []
        self.sizes = []

        #att titles
        self.colourTitle = ""
        self.shapeTitle = ""
        self.sizeTitle = ""
        self.symbologyTitle = ""

        # symbology field names  Fixed gas Columns
        self.GAS_SIZE = "ioGAS_Size__"
        self.GAS_SHAPE = "ioGAS_Shape__"
        self.GAS_COLOUR = "ioGAS_Colour__"
        self.GAS_FILTER = "ioGAS_Filter__"

        self.allcolumns = {}  
       
        self.columns = [] #list of selected Column named tuples from xml (STILL NEEDED?)
        self.rows = []

        
        #list of rows as tuples of cells
        self.data = [] #todo get rid of this?

        self.viz = [] # list of row visiblity flags

        #list of rows attribute indices as 4-tuples of indices (shape, colour size and filter)
        self.atts = []
        
        #list of rows attribute indices as 3-tuples of indices (shape, colour size)
        self.symbolicAtts = []

        #both...
        self.dataAndAtts = []

        #list of unique symbology combinations as sorted list of unique of 3-tuples of indices
        self.uniqueAttCombinations = []

        #special cols (ones we don't use are here with #, for ref)
        self.specialColumnEast = ""
        self.specialColumnNorth = ""
        self.specialColumnEPSG = ""
        self.specialColumnElevation = ""
        #long
        #lat
        #datetime
        self.specialColumnID = ""
        self.specialColumnGroup = ""
        self.specialColumnFrom = ""
        self.specialColumnTo = ""

        # column index of coord fields
        self.indexX = -1
        self.indexY = -1
        self.indexZ = -1

       
    # attempt at str(self) implementation  
    def __str__(self):
        return str(self.__class__) + ": " + str(self.__dict__)


    def rowVisible(self,row, colours, shapes, sizes, filters):
    #Return true if the row is visible (based on state of its attributes) """
        if colours[row.get_colour()].visible \
                and shapes[row.get_shape()].visible \
                and sizes[row.get_size()].visible \
                and filters[row.get_filter()].visible:
            ret = True
        else:
            ret = False
        return ret
        
    # build unique attribute (not incl filter) combinations, and sort like gas
    def extractUniqueLegendCombinations(self):
        uac = set()
        for row in self.symbolicAtts:
            intRow = tuple(int(i) for i in row)
            uac.add(intRow)
        self.uniqueAttCombinations = sorted(uac, key=itemgetter(0, 1, 2))
        #self.signalling.log(3,'GasData_Base.buildUac()',f'self.uniqueAttCombinations:{self.uniqueAttCombinations}')   
        


        

        
